/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.TypeBrowseDialog;

public class InvalidEndpointInterfaceCommand
extends AbstractExecutableMarkerCommand {
    private IType m_implType;
    private IType m_annotationType;
    private IType m_portTypeInterfaceType;

    public InvalidEndpointInterfaceCommand(IType implType) {
        super(Texts.get("InvalidEndpointInterfaceSpecified", WebService.class.getSimpleName(), implType.getElementName()));
        this.m_implType = implType;
        this.m_annotationType = TypeUtility.getType((String)WebService.class.getName());
        this.setSolutionDescription("By using this task, you can change the endpoint interface.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        TypeBrowseDialog dialog = new TypeBrowseDialog(ScoutSdkUi.getShell(), Texts.get("PortTypeInterface"), Texts.get("PleaseChoosePortTypeInterface1"));
        dialog.setTypeStyle(4);
        if (dialog.open() == 0) {
            this.m_portTypeInterfaceType = dialog.getType();
            return true;
        }
        return false;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        AnnotationUpdateOperation op = new AnnotationUpdateOperation();
        op.setDeclaringType(this.m_implType);
        op.setAnnotationType(this.m_annotationType);
        op.addStringProperty("endpointInterface", this.m_portTypeInterfaceType.getFullyQualifiedName());
        new OperationJob(new IOperation[]{op}).schedule();
    }
}

