/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractStringActionPresenter
extends AbstractPropertyPresenter<String> {
    protected StyledText m_styledText;
    private String m_tooltip;
    protected ImageHyperlink m_actionLink;
    private String m_actionLinkTooltip;
    private boolean m_actionLinkEnabled;

    public AbstractStringActionPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, false);
        this.setAcceptNullValue(true);
        this.setUseLinkAsLabel(false);
        this.setResetLinkVisible(false);
        this.setActionLinkEnabled(true);
        this.callInitializer();
    }

    public String getTooltip() {
        return this.m_tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
        if (this.isControlCreated()) {
            this.m_styledText.setToolTipText(StringUtility.nvl((Object)this.m_tooltip, (String)""));
        }
    }

    public String getActionLinkTooltip() {
        return this.m_actionLinkTooltip;
    }

    public void setActionLinkTooltip(String actionTooltip) {
        this.m_actionLinkTooltip = actionTooltip;
        if (this.isControlCreated()) {
            this.m_actionLink.setToolTipText(StringUtility.nvl((Object)actionTooltip, (String)""));
        }
    }

    public void setActionLinkEnabled(boolean actionLinkEnabled) {
        this.m_actionLinkEnabled = actionLinkEnabled;
        if (this.isControlCreated()) {
            this.m_actionLink.setEnabled(actionLinkEnabled);
        }
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.m_styledText = new StyledText(composite, 2052);
        this.m_styledText.setEditable(false);
        this.m_styledText.setBackground(JaxWsSdkUtility.getColorLightGray());
        this.m_styledText.setToolTipText(StringUtility.nvl((Object)this.m_tooltip, (String)""));
        this.m_actionLink = this.getToolkit().createImageHyperlink(composite, 0);
        this.m_actionLink.setToolTipText(StringUtility.nvl((Object)this.m_actionLinkTooltip, (String)""));
        this.m_actionLink.setImage(JaxWsSdk.getImage("url_pattern.png"));
        this.m_actionLink.setEnabled(this.m_actionLinkEnabled);
        this.m_actionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                try {
                    AbstractStringActionPresenter.this.execAction();
                }
                catch (CoreException e) {
                    JaxWsSdk.logError(e);
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.numColumns = 5;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.m_styledText.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalIndent = 5;
        this.m_actionLink.setLayoutData((Object)gd);
        return composite;
    }

    @Override
    protected void setInputInternal(String input) {
        this.m_styledText.setText(StringUtility.nvl((Object)input, (String)""));
    }

    protected abstract void execAction() throws CoreException;
}

