/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class AdditionalResourcesWizardPage
extends AbstractWorkspaceWizardPage {
    private Set<File> m_files;
    private TableViewer m_tableViewer;
    private Button m_addButton;
    private Button m_removeButton;

    public AdditionalResourcesWizardPage() {
        super(AdditionalResourcesWizardPage.class.getName());
        this.setTitle(Texts.get("AdditionalResources"));
        this.setDescription(Texts.get("AddAdditionalResources1"));
    }

    protected void createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite tableComposite = new Composite(container, 0);
        this.m_tableViewer = new TableViewer(new Table(tableComposite, 67586));
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        this.m_tableViewer.getTable().setLinesVisible(false);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdditionalResourcesWizardPage.this.m_removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.m_tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && AdditionalResourcesWizardPage.this.m_removeButton.isEnabled()) {
                    IStructuredSelection selection = (IStructuredSelection)AdditionalResourcesWizardPage.this.m_tableViewer.getSelection();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        AdditionalResourcesWizardPage.this.m_files.remove(iterator.next());
                    }
                    AdditionalResourcesWizardPage.this.m_tableViewer.refresh();
                }
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.m_tableViewer, 16384, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
        nameColumn.getColumn().setResizable(false);
        nameColumn.getColumn().setText(Texts.get("Resource"));
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_tableViewer.setInput(this.m_files);
        Composite buttonComposite = new Composite(container, 0);
        this.m_addButton = new Button(buttonComposite, 0x800008);
        this.m_addButton.setText(Texts.get("Add"));
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalResourcesWizardPage.this.openFileBrowser();
            }
        });
        this.m_removeButton = new Button(buttonComposite, 0x800008);
        this.m_removeButton.setText(Texts.get("Remove"));
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AdditionalResourcesWizardPage.this.m_tableViewer.getSelection();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    AdditionalResourcesWizardPage.this.m_files.remove(iterator.next());
                }
                AdditionalResourcesWizardPage.this.m_tableViewer.refresh();
            }
        });
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        tableComposite.setLayoutData((Object)gd);
        gd = new GridData(1040);
        gd.horizontalAlignment = 128;
        buttonComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        this.m_addButton.setLayoutData((Object)new GridData(768));
        this.m_removeButton.setLayoutData((Object)new GridData(768));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
    }

    private void openFileBrowser() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        String[] filterNames = new String[]{"XSD Schema (*.xsd)", "WSDL file (*.wsdl)", "All Files (*.*)"};
        String[] filterExtensions = new String[]{"*.xsd", "*.wsdl", "*.*"};
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        if (dialog.open() != null) {
            String[] files = dialog.getFileNames();
            Path basePath = new Path(dialog.getFilterPath());
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                File file = basePath.append(filename).toFile();
                this.m_files.add(file);
                ++n2;
            }
        }
        this.m_tableViewer.refresh();
    }

    public File[] getFiles() {
        return this.m_files.toArray(new File[this.m_files.size()]);
    }

    public void setFiles(File[] files) {
        this.m_files = new HashSet<File>(Arrays.asList(files));
    }

    private class P_LabelProvider
    extends CellLabelProvider {
        private P_LabelProvider() {
        }

        public void update(ViewerCell cell) {
            File file = (File)cell.getElement();
            cell.setText(file.getName());
            String fileExtension = IOUtility.getFileExtension((String)file.getName());
            if (StringUtility.equalsIgnoreCase((String)fileExtension, (String)"wsdl")) {
                cell.setImage(JaxWsSdk.getImage("wsdl_file_obj.gif"));
            } else {
                cell.setImage(JaxWsSdk.getImage("xsdFile.gif"));
            }
        }
    }
}

