/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JavaLogFormatter
extends Formatter {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private Date m_tmpDate = new Date();

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer buf = new StringBuffer();
        this.m_tmpDate.setTime(record.getMillis());
        buf.append(TIMESTAMP_FORMAT.format(this.m_tmpDate));
        buf.append(" ");
        String levelText = record.getLevel().getName();
        if ("SEVERE".equals(levelText)) {
            levelText = "ERROR";
        }
        buf.append(levelText);
        buf.append(" ");
        if (record.getSourceClassName() != null) {
            buf.append(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                buf.append(".");
                buf.append(record.getSourceMethodName());
            }
        } else {
            buf.append(record.getLoggerName());
        }
        buf.append(" ");
        buf.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            buf.append("\n");
            try {
                StringWriter sw = new StringWriter();
                PrintWriter p = new PrintWriter(sw);
                record.getThrown().printStackTrace(p);
                p.close();
                buf.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("\n");
        return buf.toString();
    }
}

