/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.session;

import java.security.AccessController;
import javax.security.auth.Subject;
import javax.xml.ws.WebServiceException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public class DefaultServerSessionFactory
implements IServerSessionFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultServerSessionFactory.class);
    public static final String PROP_SN_BUNDLE = String.valueOf(DefaultServerSessionFactory.class.getName()) + "#snBundle";
    public static final String PROP_QN_SESSION = String.valueOf(DefaultServerSessionFactory.class.getName()) + "#qnSession";

    @Override
    public IServerSession create() {
        String qnSession = Activator.getDefault().getBundle().getBundleContext().getProperty(PROP_QN_SESSION);
        String snBundle = Activator.getDefault().getBundle().getBundleContext().getProperty(PROP_SN_BUNDLE);
        try {
            Class<? extends IServerSession> sessionClazz = this.getSessionClass(qnSession, snBundle, PROP_QN_SESSION, PROP_SN_BUNDLE);
            Subject subject = this.safeGetSubject();
            return ((IServerJobService)SERVICES.getService(IServerJobService.class)).createServerSession(sessionClazz, subject);
        }
        catch (ProcessingException e) {
            throw new WebServiceException("Session could not be created.", (Throwable)e);
        }
    }

    private Class<? extends IServerSession> getSessionClass(String sessionClass, String bundleName, String sessionClassProperty, String bundleNameProperty) throws ProcessingException {
        Class<? extends IServerSession> classByProperty = this.findByProperties(sessionClass, bundleName, sessionClassProperty, bundleNameProperty);
        if (classByProperty != null) {
            return classByProperty;
        }
        return ((IServerJobService)SERVICES.getService(IServerJobService.class)).getServerSessionClass();
    }

    private Class<? extends IServerSession> findByProperties(String session, String bundleName, String sessionProperty, String bundleProperty) {
        Bundle bundle;
        if (!StringUtility.hasText((CharSequence)session)) {
            return null;
        }
        if (!StringUtility.hasText((CharSequence)bundleName) && session.split("\\.").length == 0) {
            LOG.error("Session class '" + session + "' configured in config.ini '" + sessionProperty + "' must be fully qualified if not used in conjunction with belonging bundle '" + bundleName + "'.");
            return null;
        }
        if (StringUtility.hasText((CharSequence)bundleName)) {
            bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                LOG.error("Bundle with the symbolic name '" + bundleName + "' configured in config.ini '" + bundleProperty + "' could not be resolved. Please ensure to have typed the symbolic name correctly and that the bundle is resolved without errors.");
                return null;
            }
        } else {
            String symbolicName = session.substring(0, session.lastIndexOf(46));
            bundle = Platform.getBundle((String)symbolicName);
            if (bundle == null) {
                LOG.error("Bundle with the symbolic name '" + symbolicName + "' configured in config.ini could not be found. The attempt to derive the symbolic name from within the configured session '" + sessionProperty + "' failed. If the package name of the session does not correspond to the symbolic name of the bundle, please specify '" + bundleProperty + "' accordingly.");
                return null;
            }
        }
        return this.loadServerSessionSafe(bundle, session);
    }

    private Class<? extends IServerSession> loadServerSessionSafe(Bundle bundle, String serverSessionFqn) {
        try {
            Class clazz = bundle.loadClass(serverSessionFqn);
            if (IServerSession.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            LOG.error("Server session class '" + serverSessionFqn + "' could not be loaded as not of the type '" + IServerSession.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Server session class '" + serverSessionFqn + "' could not be found");
        }
        return null;
    }

    private Subject safeGetSubject() {
        try {
            return Subject.getSubject(AccessController.getContext());
        }
        catch (Exception e) {
            LOG.error("Failed to get subject of calling acess context", (Throwable)e);
            throw new WebServiceException("Unexpected: missing subject in current access context.");
        }
    }
}

