/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public class NlsEntry
implements INlsEntry {
    private String m_key;
    private Map<Language, String> m_translations;
    private final INlsProject m_project;
    private final ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock(true);

    public NlsEntry(INlsEntry row) {
        this(row, row.getProject());
    }

    public NlsEntry(INlsEntry row, INlsProject project) {
        this.m_project = project;
        this.m_translations = new HashMap<Language, String>();
        this.update(row);
    }

    public NlsEntry(String key, INlsProject project) {
        this.m_translations = new HashMap<Language, String>();
        this.m_project = project;
        this.m_key = key;
    }

    @Override
    public INlsProject getProject() {
        return this.m_project;
    }

    @Override
    public int getType() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsEntry)) {
            return false;
        }
        NlsEntry other = (NlsEntry)obj;
        try {
            this.m_lock.readLock().lock();
            boolean bl = CompareUtility.equals((Object)this.m_key, (Object)other.m_key) && CompareUtility.equals(this.m_translations, other.m_translations) && CompareUtility.equals((Object)this.getType(), (Object)other.getType());
            return bl;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public int hashCode() {
        try {
            this.m_lock.readLock().lock();
            int hash = 0;
            if (this.m_key != null) {
                hash ^= this.m_key.hashCode();
            }
            hash ^= this.m_translations.hashCode();
            int n = hash ^= this.getType();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void update(INlsEntry refEntry) {
        try {
            this.m_lock.writeLock().lock();
            Map<Language, String> allTranslations = refEntry.getAllTranslations();
            this.m_translations = new HashMap<Language, String>(allTranslations.size());
            this.m_key = refEntry.getKey();
            for (Map.Entry<Language, String> entry : allTranslations.entrySet()) {
                this.addTranslationInternal(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    @Override
    public Map<Language, String> getAllTranslations() {
        try {
            this.m_lock.readLock().lock();
            HashMap<Language, String> hashMap = new HashMap<Language, String>(this.m_translations);
            return hashMap;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected void addTranslationInternal(Language language, String text) {
        try {
            this.m_lock.writeLock().lock();
            if (text == null || "".equals(text)) {
                text = null;
            }
            this.m_translations.put(language, text);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public void addTranslation(Language language, String text) {
        this.addTranslationInternal(language, text);
    }

    public void removeTranslation(Language language) {
        try {
            this.m_lock.writeLock().lock();
            this.m_translations.remove(language);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public String getTranslation(Language language) {
        return this.getTranslation(language, false);
    }

    @Override
    public String getTranslation(Language language, boolean defaultIfNotExist) {
        try {
            Locale locale;
            this.m_lock.readLock().lock();
            String translation = this.m_translations.get(language);
            if (translation == null && defaultIfNotExist && (translation = this.m_translations.get(new Language(locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry())))) == null && (translation = this.m_translations.get(new Language(locale = new Locale(locale.getLanguage())))) == null && (translation = this.m_translations.get(Language.LANGUAGE_DEFAULT)) == null) {
                translation = "!" + this.getKey() + "!";
            }
            String string = translation;
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.m_key;
    }

    public void setKey(String key) {
        try {
            this.m_lock.writeLock().lock();
            this.m_key = key;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }
}

