/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.fields.smartfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationUtility;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.button.AbstractBackButton;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.smartfield.CustomTextLookupRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistTableForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldTable;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class MobileSmartTableForm<LOOKUP_TYPE>
extends ContentAssistTableForm<LOOKUP_TYPE> {
    private static final int DEFAULT_TABLE_PAGE_SIZE = 25;
    private P_SmartFieldListener m_smartFieldListener;
    private boolean m_acceptingProposal;

    public MobileSmartTableForm(IContentAssistField<?, LOOKUP_TYPE> smartField, boolean allowCustomText) throws ProcessingException {
        super(smartField, allowCustomText);
    }

    protected void initConfig() throws ProcessingException {
        super.initConfig();
        String title = this.getContentAssistField().getLabel();
        title = StringUtility.hasText((CharSequence)title) ? TEXTS.get((String)"MobileSmartFormTitle", (String[])new String[]{title}) : TEXTS.get((String)"MobileSmartFormTitleDefault");
        this.setTitle(title);
        this.getResultTableField().getTable().setCheckable(true);
        this.getResultTableField().getTable().addTableListener((TableListener)new P_TableListener());
        AbstractMobileTable.setPagingEnabled(this.getResultTableField().getTable(), true);
        AbstractMobileTable.setPageSize(this.getResultTableField().getTable(), 25);
        GridData tableFieldGridDataHints = this.getResultTableField().getGridDataHints();
        tableFieldGridDataHints.useUiHeight = false;
        tableFieldGridDataHints.useUiWidth = false;
        tableFieldGridDataHints.h = 2;
        tableFieldGridDataHints.fillVertical = true;
        this.getResultTableField().setGridDataHints(tableFieldGridDataHints);
        this.addFormListener(new P_FormListener());
        if (this.m_smartFieldListener == null) {
            this.m_smartFieldListener = new P_SmartFieldListener();
            this.getContentAssistField().addPropertyChangeListener((PropertyChangeListener)this.m_smartFieldListener);
        }
    }

    protected void execDisposeForm() throws ProcessingException {
        super.execDisposeForm();
        if (this.m_smartFieldListener != null) {
            this.getContentAssistField().removePropertyChangeListener((PropertyChangeListener)this.m_smartFieldListener);
            this.m_smartFieldListener = null;
        }
    }

    protected int getConfiguredDisplayHint() {
        return 0;
    }

    protected boolean getConfiguredModal() {
        return true;
    }

    protected boolean getConfiguredAskIfNeedSave() {
        return true;
    }

    protected void execResultTableRowClicked(ITableRow row) throws ProcessingException {
    }

    private void acceptProposal() throws ProcessingException {
        this.m_acceptingProposal = true;
        try {
            ILookupRow<LOOKUP_TYPE> lookupRow = this.getAcceptedProposal();
            if (lookupRow != null) {
                this.getContentAssistField().acceptProposal(lookupRow);
            }
        }
        finally {
            this.m_acceptingProposal = false;
        }
    }

    public ILookupRow<LOOKUP_TYPE> getAcceptedProposal() throws ProcessingException {
        ILookupRow row = this.getSelectedLookupRow();
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.isAllowCustomText()) {
            return new CustomTextLookupRow((String)this.getFilterField().getValue());
        }
        return new LookupRow(null, "", null, null, null, null, null, true);
    }

    public MainBox.GroupBox.FilterField getFilterField() {
        return (MainBox.GroupBox.FilterField)this.getFieldByClass(MainBox.GroupBox.FilterField.class);
    }

    protected void execDecorateTable(IContentAssistFieldTable<LOOKUP_TYPE> table) {
        table.setMenus(this.getContentAssistField().getMenus());
    }

    private void handleTableRowsUpdated(List<? extends ITableRow> rows) {
        if (CollectionUtility.hasElements(rows)) {
            try {
                this.acceptProposal();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    public class MainBox
    extends ContentAssistTableForm.MainBox {
        public MainBox() {
            super((ContentAssistTableForm)MobileSmartTableForm.this);
        }

        protected void execInitField() throws ProcessingException {
            super.execInitField();
            DeviceTransformationConfig config = DeviceTransformationUtility.getDeviceTransformationConfig();
            if (config != null) {
                config.excludeFieldTransformation((IFormField)this, MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
            }
        }

        protected int getConfiguredHeightInPixel() {
            return 400;
        }

        @Order(value=99.0)
        public class BackButton
        extends AbstractBackButton {
        }

        @Order(value=1.0)
        public class GroupBox
        extends AbstractGroupBox {
            protected boolean getConfiguredBorderVisible() {
                return true;
            }

            @Order(value=1.0)
            public class FilterField
            extends AbstractStringField {
                protected void execInitField() throws ProcessingException {
                    this.setValue(MobileSmartTableForm.this.getContentAssistField().getDisplayText());
                }

                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                protected boolean getConfiguredUpdateDisplayTextOnModify() {
                    return true;
                }

                protected void execChangedDisplayText() {
                    MobileSmartTableForm.this.getContentAssistField().doSearch(this.getDisplayText(), false, false);
                }
            }
        }
    }

    private class P_FormListener
    implements FormListener {
        private P_FormListener() {
        }

        public void formChanged(FormEvent e) throws ProcessingException {
            switch (e.getType()) {
                case 3010: {
                    ILookupRow row;
                    if (e.getForm() != MobileSmartTableForm.this) {
                        return;
                    }
                    MobileSmartTableForm.this.removeFormListener(this);
                    if (MobileSmartTableForm.this.getCloseSystemType() != 3 || !((row = MobileSmartTableForm.this.getAcceptedProposal()) instanceof CustomTextLookupRow)) break;
                    MobileSmartTableForm.this.getContentAssistField().setDisplayText(row.getText());
                }
            }
        }
    }

    private class P_SmartFieldListener
    implements PropertyChangeListener {
        private P_SmartFieldListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName()) && !MobileSmartTableForm.this.m_acceptingProposal) {
                MobileSmartTableForm.this.getFilterField().setValue(MobileSmartTableForm.this.getContentAssistField().getDisplayText());
            }
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 101: {
                    MobileSmartTableForm.this.handleTableRowsUpdated(e.getRows());
                }
            }
        }
    }
}

