/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.busy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistTreeForm;

public abstract class AbstractBusyHandler
implements IBusyHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBusyHandler.class);
    private static final QualifiedName TIMER_PROPERTY = new QualifiedName(AbstractBusyHandler.class.getName(), "timer");
    private static final QualifiedName BUSY_OPERATION_PROPERTY = new QualifiedName(AbstractBusyHandler.class.getName(), "busy");
    private final IClientSession m_session;
    private final Object m_stateLock = new Object();
    private final Set<Job> m_list = Collections.synchronizedSet(new HashSet());
    private long m_shortOperationMillis = 200L;
    private long m_longOperationMillis = 3000L;
    private boolean m_enabled = true;
    private int m_blockingCount;
    private final Object m_blockingCountLock = new Object();

    public AbstractBusyHandler(IClientSession session) {
        this.m_session = session;
    }

    @Override
    public boolean acceptJob(Job job) {
        if (job == null) {
            return false;
        }
        return job instanceof ClientJob && ((ClientJob)job).isSync();
    }

    @Override
    public void onJobBegin(Job job) {
        this.addTimer(job);
    }

    @Override
    public void onJobEnd(Job job) {
        this.removeTimer(job);
        if (this.isBusyOperationNoLock(job)) {
            this.removeBusyOperation(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBlockingBegin() {
        Object object = this.m_blockingCountLock;
        synchronized (object) {
            ++this.m_blockingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBlockingEnd() {
        Object object = this.m_blockingCountLock;
        synchronized (object) {
            if (this.m_blockingCount == 0) {
                return;
            }
            --this.m_blockingCount;
            if (this.m_blockingCount == 0) {
                this.m_blockingCountLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlocking() {
        Object object = this.m_blockingCountLock;
        synchronized (object) {
            return this.m_blockingCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForBlockingToEnd() {
        Object object = this.m_blockingCountLock;
        synchronized (object) {
            while (true) {
                if (!this.isBlocking()) {
                    return;
                }
                LOG.debug("Waiting for the application to exit blocking mode");
                try {
                    this.m_blockingCountLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for the application to exit blocking mode.");
                }
            }
        }
    }

    @Override
    public final Object getStateLock() {
        return this.m_stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.getStateLock();
        synchronized (object) {
            for (Job job : this.m_list) {
                try {
                    job.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean shouldRunBusy(Job job) {
        Boolean b = (Boolean)job.getProperty(ContentAssistTreeForm.JOB_PROPERTY_LOAD_TREE);
        return b == null || b == false;
    }

    protected abstract void runBusy(Job var1);

    @Override
    public final boolean isBusy() {
        return this.m_list.size() > 0;
    }

    @Override
    public long getShortOperationMillis() {
        return this.m_shortOperationMillis;
    }

    public void setShortOperationMillis(long shortOperationMillis) {
        this.m_shortOperationMillis = shortOperationMillis;
    }

    @Override
    public long getLongOperationMillis() {
        return this.m_longOperationMillis;
    }

    public void setLongOperationMillis(long longOperationMillis) {
        this.m_longOperationMillis = longOperationMillis;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    private void addTimer(Job job) {
        P_TimerJob t = new P_TimerJob(job);
        job.setProperty(TIMER_PROPERTY, (Object)t);
        t.schedule(this.getShortOperationMillis());
    }

    private void removeTimer(Job job) {
        P_TimerJob t = (P_TimerJob)((Object)job.getProperty(TIMER_PROPERTY));
        if (t != null) {
            t.cancel();
            job.setProperty(TIMER_PROPERTY, null);
        }
    }

    private P_TimerJob getTimer(Job job) {
        return (P_TimerJob)((Object)job.getProperty(TIMER_PROPERTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBusyOperation(Job job) {
        int newSize;
        int oldSize;
        Object object = this.getStateLock();
        synchronized (object) {
            job.setProperty(BUSY_OPERATION_PROPERTY, (Object)"true");
            oldSize = this.m_list.size();
            this.m_list.add(job);
            newSize = this.m_list.size();
            this.getStateLock().notifyAll();
        }
        if (oldSize == 0 && newSize == 1) {
            this.runBusy(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBusyOperation(Job job) {
        Object object = this.getStateLock();
        synchronized (object) {
            job.setProperty(BUSY_OPERATION_PROPERTY, null);
            this.m_list.remove(job);
            this.getStateLock().notifyAll();
        }
    }

    private boolean isBusyOperationNoLock(Job job) {
        return "true".equals(job.getProperty(BUSY_OPERATION_PROPERTY));
    }

    private static boolean isJobActive(Job job) {
        if (job.getState() != 4) {
            return false;
        }
        return !(job instanceof ClientJob) || !((ClientJob)job).isWaitFor();
    }

    private class P_TimerJob
    extends Job {
        private final Job m_job;

        public P_TimerJob(Job job) {
            super("TimerJob");
            this.setSystem(true);
            this.m_job = job;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this != AbstractBusyHandler.this.getTimer(this.m_job)) {
                return Status.OK_STATUS;
            }
            AbstractBusyHandler.this.removeTimer(this.m_job);
            if (AbstractBusyHandler.isJobActive(this.m_job)) {
                if (!AbstractBusyHandler.this.isEnabled() || !AbstractBusyHandler.this.shouldRunBusy(this.m_job)) {
                    return Status.OK_STATUS;
                }
                AbstractBusyHandler.this.addBusyOperation(this.m_job);
            }
            if (!AbstractBusyHandler.isJobActive(this.m_job)) {
                AbstractBusyHandler.this.removeBusyOperation(this.m_job);
            }
            return Status.OK_STATUS;
        }
    }
}

