/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;

public class BatchSplit {
    private List<ILookupCall<?>> m_calls;
    private boolean[] m_local;
    private int m_localCount;
    private int m_remoteCount;
    private Map<ILookupCall<?>, List<ILookupRow<?>>> m_results;

    public BatchSplit(BatchLookupCall batch) {
        this(batch.getCallBatch());
    }

    public BatchSplit(List<ILookupCall<?>> calls) {
        this.m_calls = calls;
        this.m_local = new boolean[this.m_calls.size()];
        int i = 0;
        while (i < this.m_calls.size()) {
            ILookupCall<?> call = this.m_calls.get(i);
            if (call != null) {
                if (call instanceof LocalLookupCall) {
                    this.m_local[i] = true;
                    ++this.m_localCount;
                } else {
                    this.m_local[i] = false;
                    ++this.m_remoteCount;
                }
            }
            ++i;
        }
        this.m_results = new HashMap();
    }

    public int getLocalCallCount() {
        return this.m_localCount;
    }

    public List<ILookupCall<?>> getLocalCalls() {
        ArrayList localResult = new ArrayList();
        int i = 0;
        while (i < this.m_calls.size()) {
            ILookupCall<?> call = this.m_calls.get(i);
            if (call != null && this.m_local[i]) {
                localResult.add(call);
            }
            ++i;
        }
        return localResult;
    }

    public int getRemoteCallCount() {
        return this.m_remoteCount;
    }

    public List<ILookupCall<?>> getRemoteCalls() {
        ArrayList remoteResult = new ArrayList();
        int i = 0;
        while (i < this.m_calls.size()) {
            ILookupCall<?> call = this.m_calls.get(i);
            if (call != null && !this.m_local[i]) {
                remoteResult.add(call);
            }
            ++i;
        }
        return remoteResult;
    }

    public void setLocalResults(List<List<ILookupRow<?>>> data) {
        int k = 0;
        int i = 0;
        while (i < this.m_calls.size()) {
            ILookupCall<?> call = this.m_calls.get(i);
            if (call != null && this.m_local[i]) {
                this.m_results.put(call, data.get(k));
                ++k;
            }
            ++i;
        }
    }

    public void setRemoteResults(List<List<ILookupRow<?>>> data) {
        int k = 0;
        int i = 0;
        while (i < this.m_calls.size()) {
            ILookupCall<?> call = this.m_calls.get(i);
            if (call != null && !this.m_local[i]) {
                this.m_results.put(call, data.get(k));
                ++k;
            }
            ++i;
        }
    }

    public List<List<ILookupRow<?>>> getCombinedResults() {
        ArrayList result = new ArrayList();
        for (ILookupCall<?> call : this.m_calls) {
            result.add(this.m_results.get(call));
        }
        return result;
    }
}

