/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.menu.root.IContextMenuExtension;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuEvent;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuListener;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;

public abstract class AbstractContextMenu
extends AbstractMenu
implements IContextMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMenu.class);
    private final EventListenerList m_listeners = new EventListenerList();
    private final IPropertyObserver m_owner;
    private PropertyChangeListener m_menuVisibilityListener = new P_VisibilityOfMenuItemChangedListener();

    public AbstractContextMenu(IPropertyObserver owner, List<? extends IMenu> initialChildList) {
        this(owner, initialChildList, true);
    }

    public AbstractContextMenu(IPropertyObserver owner, List<? extends IMenu> initialChildList, boolean callInitializer) {
        super(false);
        this.m_owner = owner;
        if (callInitializer) {
            this.callInitializer();
        }
        this.setChildActions(initialChildList);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.calculateLocalVisibility();
    }

    @Override
    public IPropertyObserver getOwner() {
        return this.m_owner;
    }

    @Override
    public Set<? extends IMenuType> getCurrentMenuTypes() {
        return (Set)this.propertySupport.getProperty("currentMenuTypes");
    }

    protected void setCurrentMenuTypes(Set<? extends IMenuType> menuTypes) {
        this.propertySupport.setProperty("currentMenuTypes", menuTypes);
    }

    @Override
    public void addContextMenuListener(ContextMenuListener listener) {
        this.m_listeners.add(ContextMenuListener.class, (EventListener)listener);
    }

    @Override
    public void removeContextMenuListener(ContextMenuListener listener) {
        this.m_listeners.remove(ContextMenuListener.class, (EventListener)listener);
    }

    protected void fireContextMenuEvent(ContextMenuEvent event) {
        ContextMenuListener[] contextMenuListenerArray = (ContextMenuListener[])this.m_listeners.getListeners(ContextMenuListener.class);
        int n = contextMenuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContextMenuListener l = contextMenuListenerArray[n2];
            try {
                l.contextMenuChanged(event);
            }
            catch (Exception e) {
                LOG.error("Error during listener notification '" + l + "'.", (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public void addChildActions(Collection<? extends IMenu> actionList) {
        super.addChildActions(actionList);
    }

    @Override
    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.addScoutMenuVisibilityListenerRec(newChildMenus);
        this.calculateLocalVisibility();
        this.fireContextMenuEvent(new ContextMenuEvent(this, ContextMenuEvent.TYPE_STRUCTURE_CHANGED));
    }

    @Override
    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.removeScoutMenuVisibilityListenerRec(childMenusToRemove);
        this.calculateLocalVisibility();
        this.fireContextMenuEvent(new ContextMenuEvent(this, ContextMenuEvent.TYPE_STRUCTURE_CHANGED));
    }

    protected void handleChildActionsChanged(List<IMenu> oldValue, List<IMenu> newValue) {
        this.removeScoutMenuVisibilityListenerRec(oldValue);
        this.addScoutMenuVisibilityListenerRec(newValue);
        this.fireContextMenuEvent(new ContextMenuEvent(this, ContextMenuEvent.TYPE_STRUCTURE_CHANGED));
    }

    protected void addScoutMenuVisibilityListenerRec(Collection<? extends IMenu> menus) {
        if (menus != null) {
            for (IMenu iMenu : menus) {
                iMenu.addPropertyChangeListener("childActions", this.m_menuVisibilityListener);
                iMenu.addPropertyChangeListener("visible", this.m_menuVisibilityListener);
                this.addScoutMenuVisibilityListenerRec(iMenu.getChildActions());
            }
        }
    }

    protected void removeScoutMenuVisibilityListenerRec(Collection<? extends IMenu> menus) {
        if (menus != null) {
            for (IMenu iMenu : menus) {
                iMenu.removePropertyChangeListener("childActions", this.m_menuVisibilityListener);
                iMenu.removePropertyChangeListener("visible", this.m_menuVisibilityListener);
                this.removeScoutMenuVisibilityListenerRec(iMenu.getChildActions());
            }
        }
    }

    @Override
    public void callAboutToShow(final IActionFilter filter) {
        this.acceptVisitor(new IActionVisitor(){

            @Override
            public int visit(IAction action) {
                if (action instanceof IMenu && (filter == null || filter.accept(action))) {
                    IMenu menu = (IMenu)action;
                    menu.aboutToShow();
                    menu.prepareAction();
                }
                return 1;
            }
        });
    }

    protected void calculateLocalVisibility() {
        final IActionFilter activeFilter = ActionUtility.createMenuFilterMenuTypes(this.getCurrentMenuTypes(), true);
        if (activeFilter != null) {
            final BooleanHolder visibleHolder = new BooleanHolder(Boolean.valueOf(false));
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        if (menu.hasChildActions() || menu.isSeparator() || menu instanceof IContextMenu) {
                            return 1;
                        }
                        if (activeFilter.accept(menu)) {
                            visibleHolder.setValue((Object)true);
                            return 0;
                        }
                    }
                    return 1;
                }
            });
            this.setVisible((Boolean)visibleHolder.getValue());
        }
    }

    @Override
    protected IContextMenuExtension<? extends AbstractContextMenu> createLocalExtension() {
        return new LocalContextMenuExtension<AbstractContextMenu>(this);
    }

    protected static class LocalContextMenuExtension<OWNER extends AbstractContextMenu>
    extends AbstractMenu.LocalMenuExtension<OWNER>
    implements IContextMenuExtension<OWNER> {
        public LocalContextMenuExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_VisibilityOfMenuItemChangedListener
    implements PropertyChangeListener {
        private P_VisibilityOfMenuItemChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("childActions".equals(evt.getPropertyName())) {
                AbstractContextMenu.this.handleChildActionsChanged((List)evt.getOldValue(), (List)evt.getNewValue());
            }
            AbstractContextMenu.this.calculateLocalVisibility();
        }
    }
}

