/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IActivityMapContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.MenuOwnerChangedVisitor;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;

public class ActivityMapContextMenu
extends AbstractPropertyObserverContextMenu<IActivityMap<?, ?>>
implements IActivityMapContextMenu {
    public ActivityMapContextMenu(IActivityMap<?, ?> owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForActivityMapSelection(((IActivityMap)this.getOwner()).getSelectedActivityCell()));
        this.calculateLocalVisibility();
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            CompositeObject ownerValue = new CompositeObject(new Object[]{((IActivityMap)this.getOwner()).getSelectedActivityCell(), ((IActivityMap)this.getOwner()).getSelectedResourceIds(), ((IActivityMap)this.getOwner()).getSelectedBeginTime(), ((IActivityMap)this.getOwner()).getSelectedEndTime()});
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForActivityMapSelection(((IActivityMap)this.getOwner()).getSelectedActivityCell()));
            this.acceptVisitor(new MenuOwnerChangedVisitor(ownerValue, this.getCurrentMenuTypes()));
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("selectedActivityCell".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        } else if ("selectedResourceIds".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        } else if ("selectedBeginTime".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        } else if ("selectedEndTime".equals(evt.getPropertyName())) {
            this.handleOwnerValueChanged();
        }
    }
}

