/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IProposalColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractContentAssistColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractProposalField;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;

public abstract class AbstractProposalColumn<LOOKUP_TYPE>
extends AbstractContentAssistColumn<String, LOOKUP_TYPE>
implements IProposalColumn<LOOKUP_TYPE> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractProposalColumn.class);

    @Override
    protected void initConfig() {
        super.initConfig();
    }

    @Override
    protected String parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        return (String)rawValue;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        cell.setText((String)cell.getValue());
    }

    @Override
    protected IFormField prepareEditInternal(final ITableRow row) throws ProcessingException {
        AbstractProposalField f = new AbstractProposalField<LOOKUP_TYPE>(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractProposalColumn.this.propertySupport.getPropertiesMap());
            }

            @Override
            public Class<String> getHolderType() {
                return String.class;
            }

            @Override
            protected void execPrepareLookup(ILookupCall<LOOKUP_TYPE> call) throws ProcessingException {
                AbstractProposalColumn.this.interceptPrepareLookup(call, row);
            }
        };
        f.setCodeTypeClass(this.getCodeTypeClass());
        f.setLookupCall(this.getLookupCall());
        f.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        f.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        f.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        f.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        f.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
        return f;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        ILookupCall call;
        ICodeType codeType = this.getCodeTypeClass() != null ? CODES.getCodeType(this.getCodeTypeClass()) : null;
        ILookupCall iLookupCall = call = this.getLookupCall() != null ? this.getLookupCall() : null;
        if (codeType != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        if (call != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        return super.compareTableRows(r1, r2);
    }

    @Override
    protected IProposalColumnExtension<LOOKUP_TYPE, ? extends AbstractProposalColumn<LOOKUP_TYPE>> createLocalExtension() {
        return new LocalProposalColumnExtension(this);
    }

    protected static class LocalProposalColumnExtension<LOOKUP_TYPE, OWNER extends AbstractProposalColumn<LOOKUP_TYPE>>
    extends AbstractContentAssistColumn.LocalContentAssistColumnExtension<String, LOOKUP_TYPE, OWNER>
    implements IProposalColumnExtension<LOOKUP_TYPE, OWNER> {
        public LocalProposalColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

