/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.navigation.internal;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.client.ui.desktop.navigation.internal.ActivateNavigationHistoryMenu;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.TablePageState;

public class UserNavigationHistory {
    private static final int MAX_HISTORY_SIZE = 25;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UserNavigationHistory.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private final LinkedList<Bookmark> m_bookmarks = new LinkedList();
    private int m_index;
    private boolean m_addStepEnabled = true;

    public Bookmark addStep(int level, IPage page) {
        Bookmark bm;
        block4: {
            if (!this.m_addStepEnabled) {
                return null;
            }
            bm = null;
            try {
                bm = ClientSyncJob.getCurrentSession().getDesktop().createBookmark(page);
                if (bm != null) break block4;
                return null;
            }
            catch (Throwable t) {
                return this.handleAddStepError(t, bm);
            }
        }
        this.decorateBookmark(bm, level, page.getCell().getText(), page.getCell().getIconId());
        return this.addStep(bm);
    }

    public Bookmark addStep(int level, String name, String iconId) {
        Bookmark bm;
        block4: {
            if (!this.m_addStepEnabled) {
                return null;
            }
            bm = null;
            try {
                bm = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
                if (bm != null) break block4;
                return null;
            }
            catch (Throwable t) {
                return this.handleAddStepError(t, bm);
            }
        }
        this.decorateBookmark(bm, level, name, iconId);
        return this.addStep(bm);
    }

    protected void decorateBookmark(Bookmark bm, int level, String name, String iconId) {
        bm.setTitle(String.valueOf(StringUtility.rpad((String)"", (String)" ", (int)(level * 2))) + name);
        bm.setIconId(iconId);
    }

    protected Bookmark handleAddStepError(Throwable t, Bookmark bm) {
        String bookmarkTitle = "";
        if (bm != null) {
            bookmarkTitle = bm.getText();
        }
        LOG.warn("Exception occured while adding step to navigation history for bookmark: " + bookmarkTitle, t);
        return null;
    }

    protected void activateBookmark(Bookmark b) throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        desktop.activateBookmark(b);
        IOutline outline = desktop.getOutline();
        if (outline != null) {
            ITable table;
            outline.scrollToSelection();
            IPage page = outline.getActivePage();
            if (page instanceof IPageWithTable) {
                Object table2 = ((IPageWithTable)page).getTable();
                if (table2 != null) {
                    table2.scrollToSelection();
                }
            } else if (page instanceof IPageWithNodes && (table = ((IPageWithNodes)page).getTable()) != null) {
                table.scrollToSelection();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Bookmark addStep(Bookmark bm) {
        block4: {
            if (!this.m_addStepEnabled) {
                return null;
            }
            if (bm == null) {
                return null;
            }
            if (this.m_index < this.m_bookmarks.size() && this.isSameBookmark(last = this.m_bookmarks.get(this.m_index), bm)) {
                this.m_bookmarks.set(this.m_index, bm);
                this.fireNavigationChanged();
                return bm;
            }
            nextPos = this.m_index + 1;
            if (nextPos >= this.m_bookmarks.size() || !bm.equals((Object)this.m_bookmarks.get(nextPos))) ** GOTO lbl18
            this.m_bookmarks.set(nextPos, bm);
            this.m_index = nextPos;
            break block4;
lbl-1000:
            // 1 sources

            {
                removedBookmark = this.m_bookmarks.removeLast();
                this.fireBookmarkRemoved(removedBookmark);
lbl18:
                // 2 sources

                ** while (nextPos < this.m_bookmarks.size())
            }
lbl19:
            // 1 sources

            this.m_bookmarks.add(bm);
            this.m_index = this.m_bookmarks.size() - 1;
            this.fireBookmarkAdded(bm);
        }
        this.truncateHistory();
        this.fireNavigationChanged();
        return bm;
    }

    private void truncateHistory() {
        while (this.m_bookmarks.size() > 25) {
            Bookmark removedBookmark = this.m_bookmarks.removeFirst();
            this.m_index = Math.max(0, this.m_index - 1);
            this.fireBookmarkRemoved(removedBookmark);
        }
    }

    private void saveCurrentStep() {
        try {
            if (this.m_index == this.m_bookmarks.size() - 1) {
                Bookmark last = this.m_bookmarks.get(this.m_index);
                Bookmark bm = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
                if (bm != null) {
                    bm.setTitle(last.getTitle());
                    bm.setIconId(last.getIconId());
                    this.m_bookmarks.set(this.m_index, bm);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isSameBookmark(Bookmark oldbm, Bookmark newbm) {
        List oldPath = oldbm.getPath();
        List newPath = newbm.getPath();
        if (CompareUtility.equals((Object)oldbm.getTitle(), (Object)newbm.getTitle()) && CompareUtility.equals((Object)oldPath.size(), (Object)newPath.size())) {
            ListIterator oldIt = oldPath.listIterator(oldPath.size());
            ListIterator newIt = newPath.listIterator(newPath.size());
            while (oldIt.hasPrevious()) {
                AbstractPageState newState;
                AbstractPageState oldState = (AbstractPageState)oldIt.previous();
                TablePageState oldNode = null;
                TablePageState newNode = null;
                if (oldState instanceof TablePageState) {
                    oldNode = (TablePageState)oldState;
                }
                if ((newState = (AbstractPageState)newIt.previous()) instanceof TablePageState) {
                    newNode = (TablePageState)newState;
                }
                if (oldNode != null && newNode != null && CompareUtility.notEquals((Object)oldNode.getSearchFormState(), (Object)newNode.getSearchFormState())) {
                    return false;
                }
                if (oldState == null || oldState.getLabel() == null || oldState.getLabel().equals(newState.getLabel())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Bookmark getActiveBookmark() {
        if (this.m_index < this.m_bookmarks.size()) {
            return this.m_bookmarks.get(this.m_index);
        }
        return null;
    }

    public List<Bookmark> getBookmarks() {
        return new ArrayList<Bookmark>(this.m_bookmarks);
    }

    public List<Bookmark> getBackwardBookmarks() {
        ArrayList<Bookmark> actions = new ArrayList<Bookmark>();
        int startIndex = 0;
        int endIndex = this.getIndex() - 1;
        if (startIndex <= endIndex) {
            int i = startIndex;
            while (i <= endIndex) {
                Bookmark b = this.m_bookmarks.get(i);
                actions.add(b);
                ++i;
            }
        }
        return actions;
    }

    public boolean hasBackwardBookmarks() {
        int startIndex = 0;
        int endIndex = this.getIndex() - 1;
        return startIndex <= endIndex;
    }

    public List<Bookmark> getForwardBookmarks() {
        ArrayList<Bookmark> actions = new ArrayList<Bookmark>();
        int startIndex = this.getIndex() + 1;
        int endIndex = this.m_bookmarks.size() - 1;
        if (startIndex >= 0 && endIndex >= startIndex) {
            int i = startIndex;
            while (i <= endIndex) {
                Bookmark b = this.m_bookmarks.get(i);
                actions.add(b);
                ++i;
            }
        }
        return actions;
    }

    public boolean hasForwardBookmarks() {
        int startIndex = this.getIndex() + 1;
        int endIndex = this.m_bookmarks.size() - 1;
        return startIndex >= 0 && endIndex >= startIndex;
    }

    public void stepForward() throws ProcessingException {
        int nextPos = this.m_index + 1;
        if (nextPos >= 0 && nextPos < this.m_bookmarks.size()) {
            this.saveCurrentStep();
            this.m_index = nextPos;
            Bookmark b = this.m_bookmarks.get(this.m_index);
            try {
                this.m_addStepEnabled = false;
                this.activateBookmark(b);
            }
            finally {
                this.m_addStepEnabled = true;
            }
            this.fireNavigationChanged();
        }
    }

    public void stepBackward() throws ProcessingException {
        int nextPos = this.m_index - 1;
        if (nextPos >= 0 && nextPos < this.m_bookmarks.size()) {
            this.saveCurrentStep();
            this.m_index = nextPos;
            this.fireNavigationChanged();
            Bookmark b = this.m_bookmarks.get(this.m_index);
            try {
                this.m_addStepEnabled = false;
                this.activateBookmark(b);
            }
            finally {
                this.m_addStepEnabled = true;
            }
        }
    }

    public void stepTo(Bookmark b) throws ProcessingException {
        int i = 0;
        while (i < this.m_bookmarks.size()) {
            if (this.m_bookmarks.get(i) == b) {
                this.saveCurrentStep();
                this.m_index = i;
                this.fireNavigationChanged();
                try {
                    this.m_addStepEnabled = false;
                    this.activateBookmark(b);
                    break;
                }
                finally {
                    this.m_addStepEnabled = true;
                }
            }
            ++i;
        }
    }

    public List<IMenu> getMenus() {
        List<Bookmark> bookmarks = this.getBookmarks();
        Bookmark current = this.getActiveBookmark();
        ArrayList<IMenu> newList = new ArrayList<IMenu>(bookmarks.size());
        for (Bookmark b : bookmarks) {
            try {
                ActivateNavigationHistoryMenu m = new ActivateNavigationHistoryMenu(b);
                m.initAction();
                if (b == current) {
                    m.setIconId("navigation_current");
                    m.setEnabled(false);
                }
                newList.add(m);
            }
            catch (ProcessingException e) {
                LOG.error("could not initialize menu for bookmark '" + b + "'.", (Throwable)e);
            }
        }
        return newList;
    }

    public int getSize() {
        return this.m_bookmarks.size();
    }

    public int getIndex() {
        return this.m_index;
    }

    public void addNavigationHistoryListener(NavigationHistoryListener listener) {
        this.m_listenerList.add(NavigationHistoryListener.class, (EventListener)listener);
    }

    public void removeNavigationHistoryListener(NavigationHistoryListener listener) {
        this.m_listenerList.remove(NavigationHistoryListener.class, (EventListener)listener);
    }

    private void fireBookmarkAdded(Bookmark bookmark) {
        NavigationHistoryEvent e = new NavigationHistoryEvent(this, 20, bookmark);
        this.fireNavigationHistoryEvent(e);
    }

    private void fireBookmarkRemoved(Bookmark bookmark) {
        NavigationHistoryEvent e = new NavigationHistoryEvent(this, 30, bookmark);
        this.fireNavigationHistoryEvent(e);
    }

    private void fireNavigationChanged() {
        NavigationHistoryEvent e = new NavigationHistoryEvent(this, 10);
        this.fireNavigationHistoryEvent(e);
    }

    private void fireNavigationHistoryEvent(NavigationHistoryEvent e) {
        EventListener[] a = this.m_listenerList.getListeners(NavigationHistoryListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((NavigationHistoryListener)a[i]).navigationChanged(e);
                ++i;
            }
        }
    }
}

