/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.documentfield;

import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.documentfield.DocumentFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.documentfield.IDocumentFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.DocumentFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.DocumentFieldListener;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.IDocumentField;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.IDocumentFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.eventdata.SaveAsData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="4c022ea1-a522-43a5-b603-954d9cb8705c")
public abstract class AbstractDocumentField
extends AbstractValueField<RemoteFile>
implements IDocumentField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDocumentField.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private IDocumentFieldUIFacade m_uiFacade;

    public AbstractDocumentField() {
        this(true);
    }

    public AbstractDocumentField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected double getConfiguredGridWeightX() {
        return 1.0;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredRulersVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredStatusBarVisible() {
        return false;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = this.createUIFacade();
        super.initConfig();
        this.setRulersVisible(this.getConfiguredRulersVisible());
        this.setStatusBarVisible(this.getConfiguredStatusBarVisible());
    }

    @Override
    public IDocumentFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setRulersVisible(boolean b) {
        this.propertySupport.setPropertyBool("rulerVisible", b);
    }

    @Override
    public boolean isRulersVisible() {
        return this.propertySupport.getPropertyBool("rulerVisible");
    }

    @Override
    public void setStatusBarVisible(boolean b) {
        this.propertySupport.setPropertyBool("statusBarVisible", b);
    }

    @Override
    public boolean isStatusBarVisible() {
        return this.propertySupport.getPropertyBool("statusBarVisible");
    }

    @Override
    public void addDocumentFieldListener(DocumentFieldListener listener) {
        this.m_listenerList.add(DocumentFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeDocumentFieldListener(DocumentFieldListener listener) {
        this.m_listenerList.remove(DocumentFieldListener.class, (EventListener)listener);
    }

    @Override
    public boolean isComReady() {
        return this.propertySupport.getPropertyBool("comReady");
    }

    @ConfigOperation
    protected void execComReadyStatusChanged(boolean ready) throws ProcessingException {
    }

    protected Object fireDocumentFieldEventInternal(DocumentFieldEvent e) throws ProcessingException {
        Object returnValue = null;
        ProcessingException exception = null;
        DocumentFieldListener[] listeners = (DocumentFieldListener[])this.m_listenerList.getListeners(DocumentFieldListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    Object tmp = listeners[i].documentFieldChanged(e);
                    if (returnValue == null) {
                        returnValue = tmp;
                    }
                }
                catch (ProcessingException t) {
                    exception = t;
                }
                ++i;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return returnValue;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        if (!this.isInitialized() || this.getForm().isFormLoading()) {
            return false;
        }
        Object ret = this.fireDocumentFieldEventInternal(new DocumentFieldEvent(this, 12));
        return (Boolean)TypeCastUtility.castValue((Object)ret, Boolean.TYPE);
    }

    @Override
    public RemoteFile save() throws ProcessingException {
        return this.saveAs(null, null);
    }

    @Override
    public RemoteFile saveAs(String name) throws ProcessingException {
        return this.saveAs(name, null);
    }

    @Override
    public RemoteFile saveAs(String name, String format) throws ProcessingException {
        return (RemoteFile)this.fireDocumentFieldEventInternal(new DocumentFieldEvent(this, 10, new SaveAsData(name, format)));
    }

    @Override
    public void autoResizeDocument() {
        try {
            this.fireDocumentFieldEventInternal(new DocumentFieldEvent(this, 20));
        }
        catch (ProcessingException e) {
            LOG.warn("Could not auto resize document", (Throwable)e);
        }
    }

    protected IDocumentFieldUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    protected final void interceptComReadyStatusChanged(boolean ready) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        DocumentFieldChains.DocumentFieldComReadyStatusChangedChain chain = new DocumentFieldChains.DocumentFieldComReadyStatusChangedChain(extensions);
        chain.execComReadyStatusChanged(ready);
    }

    @Override
    protected IDocumentFieldExtension<? extends AbstractDocumentField> createLocalExtension() {
        return new LocalDocumentFieldExtension<AbstractDocumentField>(this);
    }

    protected static class LocalDocumentFieldExtension<OWNER extends AbstractDocumentField>
    extends AbstractValueField.LocalValueFieldExtension<RemoteFile, OWNER>
    implements IDocumentFieldExtension<OWNER> {
        public LocalDocumentFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execComReadyStatusChanged(DocumentFieldChains.DocumentFieldComReadyStatusChangedChain chain, boolean ready) throws ProcessingException {
            ((AbstractDocumentField)this.getOwner()).execComReadyStatusChanged(ready);
        }
    }

    protected class P_UIFacade
    implements IDocumentFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setDocumentFromUI(RemoteFile remoteFile) {
            try {
                AbstractDocumentField.this.setFieldChanging(true);
                AbstractDocumentField.this.setValue(remoteFile);
            }
            finally {
                AbstractDocumentField.this.setFieldChanging(false);
            }
        }

        @Override
        public void fireComReadyFromUI(boolean comReady) {
            try {
                if (AbstractDocumentField.this.propertySupport.setPropertyBool("comReady", comReady)) {
                    AbstractDocumentField.this.interceptComReadyStatusChanged(comReady);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }
}

