/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public abstract class AbstractGroupBoxBodyGrid
implements IGroupBoxBodyGrid {
    private int m_gridRows;
    private int m_gridColumns;

    protected void setGridColumns(int gridColumns) {
        this.m_gridColumns = gridColumns;
    }

    @Override
    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    protected void setGridRows(int gridRows) {
        this.m_gridRows = gridRows;
    }

    @Override
    public int getGridRowCount() {
        return this.m_gridRows;
    }

    @Override
    public void validate(IGroupBox groupBox) {
        boolean isContainingXAndY;
        this.setGridRows(0);
        this.setGridColumns(this.computGridColumnCount(groupBox));
        int containingGridXYCount = 0;
        int notContainingGridXYCount = 0;
        ArrayList<IFormField> fieldsExceptProcessButtons = new ArrayList<IFormField>();
        for (IFormField formField : groupBox.getFields()) {
            if (formField.isVisible()) {
                if (this.isProcessButton(formField)) continue;
                fieldsExceptProcessButtons.add(formField);
                GridData hints = formField.getGridDataHints();
                if (hints.x >= 0 && hints.y >= 0) {
                    ++containingGridXYCount;
                    continue;
                }
                ++notContainingGridXYCount;
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(formField, 1);
            formField.setGridDataInternal(data);
        }
        boolean bl = isContainingXAndY = containingGridXYCount > 0 && notContainingGridXYCount == 0;
        if (isContainingXAndY) {
            this.layoutAllStatic(fieldsExceptProcessButtons);
        } else {
            this.layoutAllDynamic(fieldsExceptProcessButtons);
        }
    }

    protected boolean isProcessButton(IFormField formField) {
        return formField instanceof IButton && ((IButton)formField).isProcessButton();
    }

    protected int computGridColumnCount(IGroupBox groupBox) {
        int gridColumns = -1;
        IGroupBox tmp = groupBox;
        while (gridColumns < 0 && tmp != null) {
            gridColumns = tmp.getGridColumnCountHint();
            tmp = tmp.getParentGroupBox();
        }
        if (gridColumns < 0) {
            gridColumns = 2;
        }
        return gridColumns;
    }

    private void layoutAllStatic(List<IFormField> fields) {
        GridData hints;
        int totalGridW = 1;
        int totalGridH = 0;
        for (IFormField f : fields) {
            hints = GridDataBuilder.createFromHints(f, 1);
            totalGridW = Math.max(totalGridW, hints.x + hints.w);
            totalGridH = Math.max(totalGridH, hints.y + hints.h);
        }
        for (IFormField f : fields) {
            hints = GridDataBuilder.createFromHints(f, totalGridW);
            f.setGridDataInternal(hints);
        }
        this.setGridColumns(totalGridW);
        this.setGridRows(totalGridH);
    }

    protected abstract void layoutAllDynamic(List<IFormField> var1);

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getGridRowCount() + " " + this.getGridColumnCount() + "]";
    }

    public static GridData getGridDataFromHints(IFormField field, int groupBoxColumnCount) {
        GridData data = GridDataBuilder.createFromHints(field, groupBoxColumnCount);
        data.w = Math.min(groupBoxColumnCount, data.w);
        return data;
    }
}

