/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.smartfield.IProposalFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractProposalField<LOOKUP_KEY>
extends AbstractContentAssistField<String, LOOKUP_KEY>
implements IProposalField<LOOKUP_KEY> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractProposalField.class);
    private P_UIFacade m_uiFacade;

    public AbstractProposalField() {
        this(true);
    }

    public AbstractProposalField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = new P_UIFacade();
    }

    @Override
    public IContentAssistFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void applyLazyStyles() {
    }

    @Override
    public LOOKUP_KEY getValueAsLookupKey() {
        return null;
    }

    @Override
    public void acceptProposal(ILookupRow<LOOKUP_KEY> row) {
        this.setCurrentLookupRow(row);
        this.setValue(row.getText());
    }

    @Override
    protected void installLookupRowContext(ILookupRow<LOOKUP_KEY> row) {
        this.setCurrentLookupRow(row);
        super.installLookupRowContext(row);
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        IContentAssistFieldProposalForm smartForm = this.getProposalForm();
        ILookupRow acceptedProposalRow = null;
        if (smartForm != null && StringUtility.equalsIgnoreNewLines((String)smartForm.getSearchText(), (String)text)) {
            acceptedProposalRow = smartForm.getAcceptedProposal();
        }
        try {
            String oldText = this.getDisplayText();
            boolean parsingError = this.getErrorStatus() instanceof ParsingFailedStatus;
            if (acceptedProposalRow == null && !parsingError && this.getCurrentLookupRow() != null && StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)oldText))) {
                String string = (String)this.getValue();
                return string;
            }
            if (acceptedProposalRow != null) {
                this.setCurrentLookupRow(acceptedProposalRow);
                String string = acceptedProposalRow.getText();
                return string;
            }
            if (text == null) {
                this.setCurrentLookupRow(this.EMPTY_LOOKUP_ROW);
                return null;
            }
            this.setCurrentLookupRow(null);
            this.doSearch(text, false, true);
            smartForm = this.getProposalForm();
            if (smartForm != null) {
                acceptedProposalRow = smartForm.getAcceptedProposal();
                if (acceptedProposalRow != null) {
                    this.setCurrentLookupRow(acceptedProposalRow);
                    String string = acceptedProposalRow.getText();
                    return string;
                }
                this.registerProposalFormInternal(smartForm);
                smartForm = null;
                this.setCurrentLookupRow(null);
            }
            String string = text;
            return string;
        }
        finally {
            this.unregisterProposalFormInternal(smartForm);
        }
    }

    @Override
    protected String formatValueInternal(String validKey) {
        if (!this.isCurrentLookupRowValid(validKey)) {
            this.setCurrentLookupRow(null);
        }
        if (this.getCurrentLookupRow() != null) {
            this.installLookupRowContext(this.getCurrentLookupRow());
            String text = this.getCurrentLookupRow().getText();
            if (text != null) {
                text = text.replaceAll("[\\n\\r]+", " ");
            }
            return text;
        }
        return validKey;
    }

    @Override
    protected IContentAssistFieldProposalForm<LOOKUP_KEY> createProposalForm() throws ProcessingException {
        return this.createProposalForm(true);
    }

    @Override
    protected void handleProposalFormClosed(IContentAssistFieldProposalForm<LOOKUP_KEY> proposalForm) throws ProcessingException {
        if (this.getProposalForm() == proposalForm) {
            ILookupRow<LOOKUP_KEY> row;
            if (proposalForm.getCloseSystemType() == 3 && (row = proposalForm.getAcceptedProposal()) != null) {
                this.acceptProposal(row);
            }
            this.registerProposalFormInternal(null);
        }
    }

    @Override
    protected void filterKeyLookup(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        super.filterKeyLookup(call, result);
        if (result.size() == 0) {
            String key = "" + call.getKey();
            result.add((ILookupRow<LOOKUP_KEY>)new LookupRow(call.getKey(), key));
        }
    }

    @Override
    protected void handleFetchResult(IContentAssistFieldDataFetchResult<LOOKUP_KEY> result) {
        IContentAssistFieldProposalForm<LOOKUP_KEY> smartForm = this.getProposalForm();
        if (result == null) {
            this.unregisterProposalFormInternal(smartForm);
        } else {
            List<ILookupRow<LOOKUP_KEY>> rows = result.getLookupRows();
            if ((rows == null || rows.isEmpty()) && !UserAgentUtility.isTouchDevice()) {
                this.unregisterProposalFormInternal(smartForm);
            } else {
                try {
                    if (smartForm == null) {
                        smartForm = this.createProposalForm();
                        smartForm.startForm();
                        this.registerProposalFormInternal(smartForm);
                    }
                    smartForm.dataFetchedDelegate(result, this.getBrowseMaxRowCount());
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
            }
        }
    }

    @Override
    protected IProposalFieldExtension<LOOKUP_KEY, ? extends AbstractProposalField<LOOKUP_KEY>> createLocalExtension() {
        return new LocalProposalFieldExtension(this);
    }

    protected static class LocalProposalFieldExtension<LOOKUP_KEY, OWNER extends AbstractProposalField<LOOKUP_KEY>>
    extends AbstractContentAssistField.LocalContentAssistFieldExtension<String, LOOKUP_KEY, OWNER>
    implements IProposalFieldExtension<LOOKUP_KEY, OWNER> {
        public LocalProposalFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_UIFacade
    implements IContentAssistFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String text) {
            block8: {
                String currentValidText;
                block7: {
                    currentValidText = (String)AbstractProposalField.this.getValue();
                    IContentAssistFieldProposalForm smartForm = AbstractProposalField.this.getProposalForm();
                    try {
                        if (smartForm != null && smartForm.getAcceptedProposal() != null) {
                            return this.acceptProposalFromUI();
                        }
                        if (smartForm == null || !StringUtility.equalsIgnoreNewLines((String)text, (String)smartForm.getSearchText()) && !StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) break block7;
                        if (text == null || text.length() == 0) {
                            boolean b = AbstractProposalField.this.parseValue(text);
                            return b;
                        }
                        if (!StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) {
                            return AbstractProposalField.this.parseValue(text);
                        }
                        smartForm.doClose();
                        return true;
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                        return true;
                    }
                }
                if (!CompareUtility.equals((Object)text, (Object)currentValidText)) break block8;
                return true;
            }
            return AbstractProposalField.this.parseValue(text);
        }

        @Override
        public void openProposalFromUI(String newText, boolean selectCurrentValue) {
            IContentAssistFieldProposalForm smartForm;
            if (newText == null) {
                newText = "*";
            }
            if ((smartForm = AbstractProposalField.this.getProposalForm()) == null) {
                AbstractProposalField.this.setActiveFilter(TriState.TRUE);
                AbstractProposalField.this.doSearch(newText, selectCurrentValue, false);
            } else if (!StringUtility.equalsIgnoreNewLines((String)AbstractProposalField.this.getLookupRowFetcher().getLastSearchText(), (String)newText)) {
                AbstractProposalField.this.doSearch(newText, false, false);
            }
        }

        @Override
        public boolean acceptProposalFromUI() {
            block4: {
                IContentAssistFieldProposalForm smartForm;
                block6: {
                    block5: {
                        smartForm = AbstractProposalField.this.getProposalForm();
                        if (smartForm == null) break block4;
                        if (smartForm.getAcceptedProposal() == null) break block5;
                        smartForm.doOk();
                        return true;
                    }
                    if (!StringUtility.isNullOrEmpty((CharSequence)AbstractProposalField.this.getDisplayText())) break block6;
                    return true;
                }
                try {
                    smartForm.forceProposalSelection();
                    return false;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
            }
            return false;
        }

        @Override
        public void unregisterProposalFormFromUI(IContentAssistFieldProposalForm form) {
            AbstractProposalField.this.unregisterProposalFormInternal(form);
        }
    }
}

