/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.stringfield;

import java.net.URL;
import java.util.List;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.stringfield.IStringFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.stringfield.StringFieldChains;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringFieldUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

@ClassId(value="d8b1f73a-4415-4477-8408-e6ada9e69551")
public abstract class AbstractStringField
extends AbstractBasicField<String>
implements IStringField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractStringField.class);
    private IStringFieldUIFacade m_uiFacade;
    private Boolean m_monitorSpelling = null;

    public AbstractStringField() {
        this(true);
    }

    public AbstractStringField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected IStringFieldExtension<? extends AbstractStringField> createLocalExtension() {
        return new LocalStringFieldExtension<AbstractStringField>(this);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredDecorationLink() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=240.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredFormatLower() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    @ValidationRule(value="maxLength")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    protected boolean getConfiguredFormatUpper() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    protected boolean getConfiguredWrapText() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=330.0)
    protected String getConfiguredValueFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=340.0)
    protected boolean getConfiguredSelectAllOnFocus() {
        return true;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected TransferObject execDragRequest() {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execLinkAction(URL url) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setInputMasked(this.getConfiguredInputMasked());
        super.initConfig();
        if (this.getConfiguredFormatLower()) {
            this.setFormatLower();
        } else if (this.getConfiguredFormatUpper()) {
            this.setFormatUpper();
        } else {
            this.setFormat(this.getConfiguredFormat());
        }
        this.setDecorationLink(this.getConfiguredDecorationLink());
        this.setWrapText(this.getConfiguredWrapText());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setSelectAllOnFocus(this.getConfiguredSelectAllOnFocus() && !this.getConfiguredMultilineText());
        int configuredDragType = this.getConfiguredDragType();
        if (4 == configuredDragType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDragType = 0;
        }
        this.setDragType(configuredDragType);
        int configuredDropType = this.getConfiguredDropType();
        if (4 == configuredDropType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDropType = 0;
        }
        this.setDropType(configuredDropType);
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        if (this.isInitialized()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    protected String validateValueInternal(String rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue = super.validateValueInternal(rawValue);
        if (validValue != null && validValue.length() == 0) {
            validValue = null;
        }
        if (validValue != null) {
            if (validValue.length() > this.getMaxLength()) {
                validValue = validValue.substring(0, this.getMaxLength());
            }
            if (this.isFormatUpper()) {
                validValue = validValue.toUpperCase();
            } else if (this.isFormatLower()) {
                validValue = validValue.toLowerCase();
            }
        }
        if (validValue != null && !this.isMultilineText()) {
            validValue = StringUtility.trimNewLines((String)validValue);
            validValue = validValue.replaceAll("\r\n", " ").replaceAll("[\r\n]", " ");
        }
        return validValue;
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setFormatUpper() {
        this.setFormat("A");
    }

    @Override
    public boolean isFormatUpper() {
        return "A".equals(this.getFormat());
    }

    @Override
    public void setFormatLower() {
        this.setFormat("a");
    }

    @Override
    public boolean isFormatLower() {
        return "a".equals(this.getFormat());
    }

    @Override
    public void setDecorationLink(boolean b) {
        this.propertySupport.setPropertyBool("decorationLink", b);
    }

    @Override
    public boolean isDecorationLink() {
        return this.propertySupport.getPropertyBool("decorationLink");
    }

    @Override
    public void setWrapText(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
    }

    @Override
    public boolean isWrapText() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public void setMultilineText(boolean b) {
        this.propertySupport.setPropertyBool("multilineText", b);
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void insertText(String s) {
        this.propertySupport.setPropertyAlwaysFire("insertText", (Object)s);
    }

    @Override
    public boolean isSelectAllOnFocus() {
        return this.propertySupport.getPropertyBool("selectAllOnFocus");
    }

    @Override
    public void setSelectAllOnFocus(boolean b) {
        this.propertySupport.setPropertyBool("selectAllOnFocus", b);
    }

    @Override
    public void select(int startIndex, int endIndex) {
        try {
            this.propertySupport.setPropertiesChanging(true);
            this.propertySupport.setPropertyInt("selectionStart", startIndex);
            this.propertySupport.setPropertyInt("selectionEnd", endIndex);
        }
        finally {
            this.propertySupport.setPropertiesChanging(false);
        }
    }

    @Override
    public int getSelectionStart() {
        return this.propertySupport.getPropertyInt("selectionStart");
    }

    @Override
    public int getSelectionEnd() {
        return this.propertySupport.getPropertyInt("selectionEnd");
    }

    @Override
    public IStringFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
        if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
            String t = this.interceptFormatValue((String)this.getValue());
            this.setDisplayText(t);
        }
    }

    @Override
    public String getFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        String fmt;
        if (text != null && text.length() == 0) {
            text = null;
        }
        if ((fmt = this.getFormat()) != null && text != null) {
            if ("a".equals(fmt)) {
                text = text.toLowerCase();
            } else if ("A".equals(fmt)) {
                text = text.toUpperCase();
            }
        }
        return text;
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public boolean isSpellCheckEnabled() {
        return !this.isDecorationLink() && !this.isFormatUpper() && !this.isFormatLower() && this.isEnabled() && this.isEnabledGranted() && !(this.getForm() instanceof ISearchForm);
    }

    @Override
    public Boolean isSpellCheckAsYouTypeEnabled() {
        return this.m_monitorSpelling;
    }

    @Override
    public void setSpellCheckAsYouTypeEnabled(boolean monitorSpelling) {
        this.m_monitorSpelling = monitorSpelling;
    }

    protected final void interceptDropRequest(TransferObject transferObject) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldDropRequestChain chain = new StringFieldChains.StringFieldDropRequestChain(extensions);
        chain.execDropRequest(transferObject);
    }

    protected final void interceptLinkAction(URL url) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldLinkActionChain chain = new StringFieldChains.StringFieldLinkActionChain(extensions);
        chain.execLinkAction(url);
    }

    protected final TransferObject interceptDragRequest() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldDragRequestChain chain = new StringFieldChains.StringFieldDragRequestChain(extensions);
        return chain.execDragRequest();
    }

    protected static class LocalStringFieldExtension<OWNER_FIELD extends AbstractStringField>
    extends AbstractBasicField.LocalBasicFieldExtension<String, OWNER_FIELD>
    implements IStringFieldExtension<OWNER_FIELD> {
        public LocalStringFieldExtension(OWNER_FIELD owner) {
            super(owner);
        }

        @Override
        public void execDropRequest(StringFieldChains.StringFieldDropRequestChain chain, TransferObject transferObject) {
            ((AbstractStringField)this.getOwner()).execDropRequest(transferObject);
        }

        @Override
        public void execLinkAction(StringFieldChains.StringFieldLinkActionChain chain, URL url) throws ProcessingException {
            ((AbstractStringField)this.getOwner()).execLinkAction(url);
        }

        @Override
        public TransferObject execDragRequest(StringFieldChains.StringFieldDragRequestChain chain) {
            return ((AbstractStringField)this.getOwner()).execDragRequest();
        }
    }

    private class P_UIFacade
    extends AbstractBasicField.P_UIFacade
    implements IStringFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText, boolean whileTyping) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            AbstractStringField.this.setWhileTyping(whileTyping);
            return AbstractStringField.this.parseValue(newText);
        }

        @Override
        public void fireLinkActionFromUI(String text) {
            URL url = IOUtility.urlTextToUrl((String)text);
            try {
                AbstractStringField.this.interceptLinkAction(url);
            }
            catch (ProcessingException e) {
                LOG.warn("execLinkAction failed", (Throwable)e);
            }
        }

        @Override
        public void fireKeyTypedFromUI(String newText) {
            String oldText = AbstractStringField.this.getDisplayText();
            if (oldText != null && oldText.length() == 0) {
                oldText = null;
            }
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            if (oldText == newText || oldText != null && oldText.equals(newText)) {
                return;
            }
            AbstractStringField.this.parseValue(newText);
        }

        @Override
        public void setSelectionFromUI(int startOfSelection, int endOfSelection) {
            AbstractStringField.this.select(startOfSelection, endOfSelection);
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            return AbstractStringField.this.interceptDragRequest();
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            AbstractStringField.this.interceptDropRequest(scoutTransferable);
        }
    }
}

