/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tabbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;

public class TabBoxGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TabBoxGrid.class);
    private ITabBox m_tabBox = null;
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public TabBoxGrid(ITabBox tabBox) {
        this.m_tabBox = tabBox;
    }

    public void validate() {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField iFormField : this.m_tabBox.getGroupBoxes()) {
            if (iFormField.isVisible()) {
                list.add(iFormField);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(iFormField, 1);
            iFormField.setGridDataInternal(data);
        }
        this.m_fields = list.toArray(new IFormField[list.size()]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        GridData data;
        int i = 0;
        while (i < this.m_fields.length) {
            data = GridDataBuilder.createFromHints(this.m_fields[i], 1);
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
            this.m_gridColumns = Math.max(this.m_gridColumns, data.w);
            ++i;
        }
        i = 0;
        while (i < this.m_fields.length) {
            data = GridDataBuilder.createFromHints(this.m_fields[i], this.m_gridColumns);
            data.x = 0;
            data.y = 0;
            this.m_fields[i].setGridDataInternal(data);
            ++i;
        }
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

