/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.cache;

import java.io.Serializable;
import org.eclipse.scout.rt.server.commons.cache.ICacheEntry;

final class CacheEntry<T>
implements ICacheEntry<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final T m_value;
    private long m_creationTime;
    private long m_expiration;

    CacheEntry(T value, long expiration, long creationTime) {
        this.m_creationTime = creationTime;
        this.m_value = value;
        this.m_expiration = expiration;
    }

    CacheEntry(T value, Long expiration) {
        this(value, expiration, System.currentTimeMillis());
    }

    @Override
    public boolean isActive() {
        return this.m_creationTime + this.m_expiration > System.currentTimeMillis();
    }

    @Override
    public T getValue() {
        return this.m_value;
    }

    @Override
    public void setExpiration(Long expiration) {
        this.m_expiration = expiration;
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    @Override
    public void touch() {
        this.m_creationTime = System.currentTimeMillis();
    }

    public String toString() {
        return "CacheElement [m_value=" + this.m_value + ", m_creationTime=" + this.m_creationTime + ", m_expiration=" + this.m_expiration + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_creationTime ^ this.m_creationTime >>> 32);
        result = 31 * result + (int)(this.m_expiration ^ this.m_expiration >>> 32);
        result = 31 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        if (this.m_creationTime != other.m_creationTime) {
            return false;
        }
        if (this.m_expiration != other.m_expiration) {
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }
}

