/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servletfilter.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.commons.cache.IHttpSessionCacheService;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.commons.servletfilter.security.PrincipalHolder;
import org.eclipse.scout.rt.server.commons.servletfilter.security.SecureHttpServletRequestWrapper;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractChainableSecurityFilter
implements Filter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractChainableSecurityFilter.class);
    public static final String PROP_SUBJECT = Subject.class.getName();
    public static final int STATUS_CONTINUE_CHAIN = 1;
    public static final int STATUS_BREAK_CHAIN = 2;
    public static final int STATUS_CONTINUE_WITH_PRINCIPAL = 3;
    private boolean m_failover;
    private String m_realm;
    private FilterConfigInjection m_injection;

    protected String getFilterId() {
        return this.getClass().getSimpleName();
    }

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
        FilterConfigInjection.FilterConfig config = this.m_injection.getAnyConfig();
        String failoverString = config.getInitParameter("failover");
        this.m_failover = Boolean.parseBoolean(failoverString);
        String realmParam = config.getInitParameter("realm");
        if (realmParam == null) {
            realmParam = "Default";
        }
        this.m_realm = realmParam;
    }

    public void destroy() {
        this.m_injection = null;
    }

    public final void doFilter(ServletRequest in, ServletResponse out, final FilterChain chain) throws IOException, ServletException {
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(in);
        if (!config.isActive()) {
            chain.doFilter(in, out);
            return;
        }
        final HttpServletRequest req = (HttpServletRequest)in;
        final HttpServletResponse res = (HttpServletResponse)out;
        req.getSession();
        Subject subject = this.findSubject(req, res);
        if (subject == null || subject.getPrincipals().size() == 0) {
            PrincipalHolder pHolder = new PrincipalHolder();
            switch (this.negotiate(req, res, pHolder)) {
                case 1: {
                    if (this.m_failover) {
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    res.sendError(401);
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    if (subject == null || subject.isReadOnly()) {
                        subject = new Subject();
                    }
                    subject.getPrincipals().add(pHolder.getPrincipal());
                    subject.setReadOnly();
                    this.cacheSubject(req, res, subject);
                }
            }
        }
        if (Subject.getSubject(AccessController.getContext()) != null) {
            this.doFilterInternal(req, res, chain);
        } else {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Object secureReq = req;
                        if (!(secureReq instanceof SecureHttpServletRequestWrapper)) {
                            Principal principal = Subject.getSubject(AccessController.getContext()).getPrincipals().iterator().next();
                            secureReq = new SecureHttpServletRequestWrapper(req, principal);
                        }
                        AbstractChainableSecurityFilter.this.doFilterInternal(secureReq, res, chain);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                throw new ServletException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject findSubject(HttpServletRequest req, HttpServletResponse res) {
        HttpSession httpSession = req.getSession();
        synchronized (httpSession) {
            Subject subject = this.getCachedSubject(req, res);
            if (subject == null) {
                subject = Subject.getSubject(AccessController.getContext());
            }
            if (subject == null) {
                Principal principal = req.getUserPrincipal();
                if (principal == null || !StringUtility.hasText((CharSequence)principal.getName())) {
                    principal = null;
                    String name = req.getRemoteUser();
                    if (StringUtility.hasText((CharSequence)name)) {
                        principal = new SimplePrincipal(name);
                    }
                }
                if (principal != null) {
                    subject = this.createSubject(principal);
                    this.cacheSubject(req, res, subject);
                }
            }
            return subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheSubject(HttpServletRequest req, HttpServletResponse res, Subject subject) {
        HttpSession httpSession = req.getSession();
        synchronized (httpSession) {
            ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).put(PROP_SUBJECT, subject, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject getCachedSubject(HttpServletRequest req, HttpServletResponse res) {
        HttpSession httpSession = req.getSession();
        synchronized (httpSession) {
            Object s = ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).getAndTouch(PROP_SUBJECT, req, res);
            if (s instanceof Subject) {
                return (Subject)s;
            }
            return null;
        }
    }

    protected Subject createSubject(Principal principal) {
        Subject s = new Subject();
        s.getPrincipals().add(principal);
        s.setReadOnly();
        return s;
    }

    protected abstract int negotiate(HttpServletRequest var1, HttpServletResponse var2, PrincipalHolder var3) throws IOException, ServletException;

    private void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public String getRealm() {
        return this.m_realm;
    }

    public boolean isFailover() {
        return this.m_failover;
    }
}

