/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IBeanArrayHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.AbstractBeanPropertyOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class BeanArrayHolderOutput
implements IBindOutput {
    private IBeanArrayHolder m_holder;
    private AbstractBeanPropertyOutput m_delegate;

    public BeanArrayHolderOutput(IBeanArrayHolder holder, String propertyName, ValueOutputToken source) throws ProcessingException {
        this.m_holder = holder;
        this.m_delegate = new AbstractBeanPropertyOutput(this.m_holder.getHolderType(), propertyName, source){

            @Override
            protected Object[] getFinalBeanArray() {
                return BeanArrayHolderOutput.this.m_holder.getBeans(new IBeanArrayHolder.State[0]);
            }
        };
    }

    @Override
    public IToken getToken() {
        return this.m_delegate.getToken();
    }

    @Override
    public boolean isJdbcBind() {
        return this.m_delegate.isJdbcBind();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_delegate.getJdbcBindIndex();
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_delegate.setJdbcBindIndex(index);
    }

    @Override
    public boolean isBatch() {
        return this.m_delegate.isBatch();
    }

    @Override
    public boolean isSelectInto() {
        return this.m_delegate.isSelectInto();
    }

    @Override
    public Class getBindType() {
        return this.m_delegate.getBindType();
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_delegate.setNextBatchIndex(i);
    }

    @Override
    public void finishBatch() throws ProcessingException {
        this.m_holder.ensureSize(this.m_delegate.getBatchIndex() + 1);
        this.m_delegate.finishBatch();
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_delegate.setReplaceToken(style);
    }

    @Override
    public void consumeValue(Object value) throws ProcessingException {
        this.m_delegate.consumeValue(value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[delegate=" + this.m_delegate + "]";
    }
}

