/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class CollectionHolderOutput
implements IBindOutput {
    private final IHolder<?> m_holder;
    private final ValueOutputToken m_source;
    private final List<Object> m_accumulator;
    private int m_batchIndex;
    private int m_jdbcBindIndex;

    public CollectionHolderOutput(IHolder<?> holder, ValueOutputToken source) {
        this.m_holder = holder;
        this.m_source = source;
        this.m_accumulator = new ArrayList<Object>();
        this.m_batchIndex = -1;
        this.m_jdbcBindIndex = -1;
    }

    @Override
    public IToken getToken() {
        return this.m_source;
    }

    @Override
    public boolean isJdbcBind() {
        return !this.m_source.isSelectInto();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public boolean isBatch() {
        return this.m_source.isBatch();
    }

    @Override
    public boolean isSelectInto() {
        return this.m_source.isSelectInto();
    }

    @Override
    public Class getBindType() {
        return this.m_holder.getHolderType().getComponentType();
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    private static <T> void setValueToHolder(IHolder<T> holder, List<Object> list) {
        Class toType = holder.getHolderType();
        if (Set.class.isAssignableFrom(toType)) {
            HashSet s = CollectionUtility.hashSet(list);
            holder.setValue((Object)s);
        } else {
            holder.setValue(list);
        }
    }

    @Override
    public void finishBatch() {
        CollectionHolderOutput.setValueToHolder(this.m_holder, this.m_accumulator);
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_source.setReplaceToken("?");
    }

    @Override
    public void consumeValue(Object value) {
        this.m_accumulator.add(value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[bindType=" + this.getBindType() + ", source=" + this.m_source + "]";
    }
}

