/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jms;

import java.util.Hashtable;
import java.util.zip.CRC32;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;

@Deprecated
public class JmsJndiConfig {
    private String m_initialContextFactory;
    private String m_providerUrl;
    private String m_userName;
    private String m_password;
    private String m_connectionFactoryJndiName;
    private String m_jndiName;

    public String getInitialContextFactory() {
        return this.m_initialContextFactory;
    }

    public void setInitialContextFactory(String contextFactory) {
        this.m_initialContextFactory = contextFactory;
    }

    public String getProviderUrl() {
        return this.m_providerUrl;
    }

    public void setProviderUrl(String url) {
        this.m_providerUrl = url;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setUserName(String name) {
        this.m_userName = name;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getConnectionFactoryJndiName() {
        return this.m_connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String factoryJndiName) {
        this.m_connectionFactoryJndiName = factoryJndiName;
    }

    public String getJndiName() {
        return this.m_jndiName;
    }

    public void setJndiName(String name) {
        this.m_jndiName = name;
    }

    public InitialContext createInitialContext() throws ProcessingException {
        InitialContext ctx;
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.m_initialContextFactory != null) {
            props.put("java.naming.factory.initial", this.m_initialContextFactory);
        }
        if (this.m_providerUrl != null) {
            props.put("java.naming.provider.url", this.m_providerUrl);
        }
        if (this.m_userName != null && this.m_userName.length() > 0) {
            props.put("java.naming.security.principal", this.m_userName);
        }
        if (this.m_password != null) {
            props.put("java.naming.security.credentials", this.m_password);
        }
        try {
            ctx = props.size() > 0 ? new InitialContext(props) : new InitialContext();
        }
        catch (NamingException e) {
            throw new ProcessingException(e.getMessage(), e.getCause());
        }
        return ctx;
    }

    public long getCrc() {
        CRC32 crc = new CRC32();
        if (this.m_connectionFactoryJndiName != null) {
            crc.update(this.m_connectionFactoryJndiName.getBytes());
        }
        if (this.m_initialContextFactory != null) {
            crc.update(this.m_initialContextFactory.getBytes());
        }
        if (this.m_jndiName != null) {
            crc.update(this.m_jndiName.getBytes());
        }
        if (this.m_password != null) {
            crc.update(this.m_password.getBytes());
        }
        if (this.m_userName != null) {
            crc.update(this.m_userName.getBytes());
        }
        if (this.m_providerUrl != null) {
            crc.update(this.m_providerUrl.getBytes());
        }
        return crc.getValue();
    }

    public int hashCode() {
        int h = 0;
        if (this.m_connectionFactoryJndiName != null) {
            h ^= this.m_connectionFactoryJndiName.hashCode();
        }
        if (this.m_initialContextFactory != null) {
            h ^= this.m_initialContextFactory.hashCode();
        }
        if (this.m_jndiName != null) {
            h ^= this.m_jndiName.hashCode();
        }
        if (this.m_password != null) {
            h ^= this.m_password.hashCode();
        }
        if (this.m_providerUrl != null) {
            h ^= this.m_providerUrl.hashCode();
        }
        if (this.m_userName != null) {
            h ^= this.m_userName.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JmsJndiConfig)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    private int compareTo(Object obj) {
        JmsJndiConfig c = (JmsJndiConfig)obj;
        if (CompareUtility.compareTo((Comparable)((Object)c.getConnectionFactoryJndiName()), (Comparable)((Object)this.m_connectionFactoryJndiName)) == 0 && CompareUtility.compareTo((Comparable)((Object)c.getInitialContextFactory()), (Comparable)((Object)this.m_initialContextFactory)) == 0 && CompareUtility.compareTo((Comparable)((Object)c.getJndiName()), (Comparable)((Object)this.m_jndiName)) == 0 && CompareUtility.compareTo((Comparable)((Object)c.getPassword()), (Comparable)((Object)this.m_password)) == 0 && CompareUtility.compareTo((Comparable)((Object)c.getProviderUrl()), (Comparable)((Object)this.m_providerUrl)) == 0 && CompareUtility.compareTo((Comparable)((Object)c.getUserName()), (Comparable)((Object)this.m_userName)) == 0) {
            return 0;
        }
        return -1;
    }
}

