/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form;

import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Data;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;

public final class FormDataUtility {
    private static final Pattern FIELD_SUFFIX_PATTERN = Pattern.compile("Field$");
    private static final Pattern BUTTON_SUFFIX_PATTERN = Pattern.compile("Button$");
    private static final Pattern DATA_SUFFIX_PATTERN = Pattern.compile("Data$");

    private FormDataUtility() {
    }

    public static String getFieldDataId(String formFieldId) {
        String s = StringUtility.trim((String)formFieldId);
        if (StringUtility.isNullOrEmpty((CharSequence)s)) {
            return null;
        }
        if (s.endsWith("Field")) {
            return FIELD_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        if (s.endsWith("Button")) {
            return BUTTON_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        return s;
    }

    public static Class<?> getDataAnnotationValue(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            Class value;
            Data annotation = clazz.getAnnotation(Data.class);
            if (annotation != null && (value = annotation.value()) != null && !Object.class.equals((Object)value)) {
                return value;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static String getFieldDataId(AbstractFormFieldData fieldData) {
        String s = fieldData.getFieldId();
        if (s != null && s.endsWith("Data")) {
            s = DATA_SUFFIX_PATTERN.matcher(s).replaceAll("");
        }
        return FormDataUtility.getFieldDataId(s);
    }
}

