/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.service.SERVICES;

public class ObjectExtensions<OWNER, EXTENSION extends IExtension<? extends OWNER>>
implements IExtensibleObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private final OWNER m_owner;
    private List<EXTENSION> m_extensions;

    public ObjectExtensions(OWNER owner) {
        this.m_owner = owner;
    }

    public List<EXTENSION> getAllExtensions() {
        if (this.m_extensions == null) {
            throw new IllegalStateException("The model object is not initialized: " + this.m_owner + ".");
        }
        return this.m_extensions;
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        if (c == null) {
            return null;
        }
        if (this.m_extensions == null) {
            throw new IllegalStateException("The model object is not initialized: " + this.m_owner + ".");
        }
        for (IExtension extension : this.m_extensions) {
            if (c != extension.getClass()) continue;
            return (T)((IExtension)c.cast(extension));
        }
        return null;
    }

    public void initConfig(EXTENSION localExtension, Runnable modelObjectInitializer) {
        if (this.m_extensions != null) {
            throw new IllegalStateException("The model object is already initialized: " + this.m_owner + ".");
        }
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class);
        try {
            extensionRegistry.pushScope(this.m_owner.getClass());
            this.m_extensions = this.loadExtensions(localExtension);
            try {
                extensionRegistry.pushExtensions(this.m_extensions);
                if (modelObjectInitializer != null) {
                    modelObjectInitializer.run();
                }
            }
            finally {
                extensionRegistry.popExtensions(this.m_extensions);
            }
        }
        finally {
            extensionRegistry.popScope();
        }
    }

    private List<EXTENSION> loadExtensions(EXTENSION localExtension) {
        List extensions = ((IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class)).createExtensionsFor(this.m_owner);
        extensions.add(localExtension);
        return Collections.unmodifiableList(extensions);
    }
}

