/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;

public class CompressedWriter
extends Writer {
    private static final String DEFAULT_CHARSETNAME = "UTF-8";
    private RemoteFile m_remoteFile;
    private ByteArrayOutputStream m_buffer;
    private Deflater m_deflater;
    private DeflaterOutputStream m_deflaterOutputStream;
    private CRC32 m_crc32;
    private String m_charsetName = "UTF-8";

    public CompressedWriter(RemoteFile f) {
        this(f, DEFAULT_CHARSETNAME);
    }

    public CompressedWriter(RemoteFile f, String charsetName) {
        this.m_remoteFile = f;
        this.m_charsetName = charsetName;
        this.m_buffer = new ByteArrayOutputStream();
        this.m_deflater = new Deflater(9);
        this.m_deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.m_buffer, this.m_deflater);
        this.m_crc32 = new CRC32();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_deflater.finish();
        this.m_deflaterOutputStream.finish();
        this.m_deflaterOutputStream.close();
        this.m_deflater.end();
        this.m_buffer.close();
        this.m_remoteFile.setCompressedData(this.m_buffer.toByteArray(), this.m_crc32.getValue());
    }

    @Override
    public void flush() throws IOException {
        this.m_deflaterOutputStream.flush();
        this.m_buffer.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            String str = new String(cbuf, off, len);
            byte[] b = str.getBytes(this.m_charsetName);
            this.m_crc32.update(b, 0, b.length);
            this.m_deflaterOutputStream.write(b, 0, b.length);
            this.flush();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

