/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.security;

import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.security.BasicHierarchyPermission;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.internal.AccessControlStore;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

@Priority(value=-1.0f)
public abstract class AbstractSharedAccessControlService
extends AbstractService
implements IAccessControlService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSharedAccessControlService.class);
    private AccessControlStore m_accessControlStore;
    private Pattern[] m_userIdSearchPatterns = new Pattern[]{Pattern.compile(".*\\\\([^/@]+)"), Pattern.compile(".*\\\\([^/@]+)[/@].*"), Pattern.compile("([^/@]+)"), Pattern.compile("([^/@]+)[/@].*")};

    protected Pattern[] getUserIdSearchPatterns() {
        return this.m_userIdSearchPatterns;
    }

    protected void setUserIdSearchPatterns(Pattern ... patterns) {
        this.m_userIdSearchPatterns = patterns;
    }

    protected void setUserIdSearchPatterns(String ... patterns) {
        Pattern[] a = new Pattern[patterns.length];
        int i = 0;
        while (i < a.length) {
            a[i] = Pattern.compile(patterns[i]);
            ++i;
        }
        this.setUserIdSearchPatterns(a);
    }

    @Override
    public String getUserIdOfCurrentSubject() {
        Subject s = Subject.getSubject(AccessController.getContext());
        if (s == null) {
            return null;
        }
        if (this.m_userIdSearchPatterns == null) {
            return null;
        }
        for (Principal p : s.getPrincipals()) {
            String name = p.getName().toLowerCase();
            Pattern[] patternArray = this.m_userIdSearchPatterns;
            int n = this.m_userIdSearchPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pat = patternArray[n2];
                Matcher m = pat.matcher(name);
                if (m.matches()) {
                    return m.group(1);
                }
                ++n2;
            }
        }
        return null;
    }

    public void initializeService(ServiceRegistration registration) {
        this.m_accessControlStore = new AccessControlStore();
        super.initializeService(registration);
    }

    @Override
    public boolean checkPermission(Permission p) {
        if (p == null) {
            return true;
        }
        Permissions c = this.getPermissions();
        if (c == null) {
            return true;
        }
        return c.implies(p);
    }

    @Override
    public int getPermissionLevel(Permission p) {
        if (p == null) {
            return 0;
        }
        if (!(p instanceof BasicHierarchyPermission)) {
            if (this.checkPermission(p)) {
                return 100;
            }
            return 0;
        }
        BasicHierarchyPermission hp = (BasicHierarchyPermission)p;
        Permissions c = this.getPermissions();
        if (c == null) {
            List<Integer> levels = hp.getValidLevels();
            return levels.get(levels.size() - 1);
        }
        int maxLevel = -1;
        Enumeration<Permission> en = c.elements();
        while (en.hasMoreElements()) {
            BasicHierarchyPermission hgrantedPermission;
            Permission grantedPermission = en.nextElement();
            if (grantedPermission instanceof AllPermission) {
                return 100;
            }
            if (grantedPermission instanceof BasicHierarchyPermission && (hgrantedPermission = (BasicHierarchyPermission)grantedPermission).getClass().isAssignableFrom(hp.getClass()) && (maxLevel = Math.max(maxLevel, hgrantedPermission.getLevel())) >= 100) break;
        }
        return maxLevel;
    }

    @Override
    public Permissions getPermissions() {
        Permissions permSet = this.m_accessControlStore.getPermissionsOfCurrentSubject();
        if (permSet != null) {
            return permSet;
        }
        this.setPermissions(this.execLoadPermissions());
        permSet = this.m_accessControlStore.getPermissionsOfCurrentSubject();
        return permSet;
    }

    protected Permissions execLoadPermissions() {
        return null;
    }

    private void setPermissions(Permissions p) {
        this.m_accessControlStore.setPermissionsOfCurrentSubject(p);
        this.notifySetPermisions(p);
    }

    protected void notifySetPermisions(Permissions permissions) {
    }

    @Override
    public boolean isProxyService() {
        return false;
    }

    @Override
    public void clearCache() {
        this.clearCacheNoFire();
    }

    @Override
    public void clearCacheOfUserIds(Collection<String> userIds) {
        this.clearCacheOfUserIdsNoFire(userIds);
    }

    protected void clearCacheNoFire() {
        this.m_accessControlStore.clearCache();
    }

    protected void clearCacheOfUserIdsNoFire(Collection<String> userIds) {
        this.m_accessControlStore.clearCacheOfUserIds(userIds);
    }
}

