/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityConfig;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.gen.FormFieldSpecsVisitor;
import org.eclipse.scout.rt.spec.client.gen.IDocFormFieldVisitor;
import org.eclipse.scout.rt.spec.client.gen.SmartFieldVisitor;
import org.eclipse.scout.rt.spec.client.gen.TableFieldVisitor;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.IDocTable;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public class FormSpecGenerator {
    private final IDocConfig m_config;

    public FormSpecGenerator(IDocConfig config) {
        this.m_config = config;
    }

    public IDocSection getDocSection(IForm form) {
        IDocEntityConfig<IForm> formConfig = this.m_config.getFormConfig();
        IDocTable formSpec = DocGenUtility.createDocTable(form, formConfig, true);
        IDocFormFieldVisitor[] visitors = new IDocFormFieldVisitor[]{new FormFieldSpecsVisitor(this.m_config), new TableFieldVisitor(this.m_config), new SmartFieldVisitor(this.m_config)};
        IDocSection[] subSections = this.getSubSections(form, visitors);
        String title = formConfig.getTitleExtractor().getText(form);
        return new Section(title, formSpec, subSections);
    }

    private IDocSection[] getSubSections(IForm form, IDocFormFieldVisitor ... visitors) {
        ArrayList<IDocSection> subSections = new ArrayList<IDocSection>();
        IDocFormFieldVisitor[] iDocFormFieldVisitorArray = visitors;
        int n = visitors.length;
        int n2 = 0;
        while (n2 < n) {
            IDocFormFieldVisitor v = iDocFormFieldVisitorArray[n2];
            subSections.addAll(this.getTableFields(form, v));
            ++n2;
        }
        return (IDocSection[])CollectionUtility.toArray(subSections, IDocSection.class);
    }

    private List<IDocSection> getTableFields(IForm form, IDocFormFieldVisitor visitor) {
        form.visitFields((IFormFieldVisitor)visitor);
        return visitor.getDocSections();
    }
}

