/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.spec.client.gen.extract.LinkableTypeExtractor;

public class ColumnTypeExtractor
extends LinkableTypeExtractor<IColumn<?>> {
    public static final String LINKS_TAG_NAME = "links";

    @Override
    public String getText(IColumn<?> column) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getText(column));
        if (column instanceof ISmartColumn) {
            sb.append(" (").append(this.getDetailText((ISmartColumn)column)).append(")");
        }
        return sb.toString();
    }

    public String getDetailText(ISmartColumn<?> smartcolumn) {
        StringBuilder text = new StringBuilder();
        Class codeTypeClass = this.getCodeTypeClass(smartcolumn);
        if (codeTypeClass != null) {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.codetype")).append(": ");
            text.append(new LinkableTypeExtractor(ICodeType.class, true).getText(this.getCodeTypeClass(smartcolumn)));
        } else if (smartcolumn.getLookupCall() != null) {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.lookupcall")).append(": ");
            text.append(new LinkableTypeExtractor<ILookupCall>(ILookupCall.class, true).getText(smartcolumn.getLookupCall()));
        } else {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.na"));
        }
        return text.toString();
    }

    protected Class getCodeTypeClass(ISmartColumn<?> smartcolumn) {
        ILookupCall lookupCall;
        Class codeTypeClass = smartcolumn.getCodeTypeClass();
        if (codeTypeClass == null && (lookupCall = smartcolumn.getLookupCall()) instanceof CodeLookupCall) {
            codeTypeClass = ((CodeLookupCall)lookupCall).getCodeTypeClass();
        }
        return codeTypeClass;
    }
}

