/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.AbstractDesktop;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.testing.client.ITestClientSessionProvider;
import org.eclipse.scout.testing.client.servicetunnel.http.MultiClientAuthenticator;
import org.osgi.framework.Bundle;

public class DefaultTestClientSessionProvider
implements ITestClientSessionProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultTestClientSessionProvider.class);
    private static final Map<String, IClientSession> CACHE = new HashMap<String, IClientSession>();
    private static final Object CACHE_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IClientSession> T getOrCreateClientSession(Class<T> clazz, final String runAs, boolean createNew) {
        Bundle bundle;
        String symbolicName = clazz.getPackage().getName();
        Bundle bundleLocator = null;
        while (symbolicName != null) {
            bundleLocator = Platform.getBundle((String)symbolicName);
            int i = symbolicName.lastIndexOf(46);
            if (bundleLocator != null || i < 0) break;
            symbolicName = symbolicName.substring(0, i);
        }
        if ((bundle = Platform.getBundle((String)symbolicName)) != null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                String cacheKey = this.createSessionCacheKey(clazz, bundle, runAs);
                IClientSession clientSession = CACHE.get(cacheKey);
                if (clientSession == null || !clientSession.isActive() || createNew) {
                    try {
                        clientSession = (IClientSession)clazz.newInstance();
                        CACHE.put(cacheKey, clientSession);
                        clientSession.setUserAgent(UserAgent.createDefault());
                        ClientSyncJob job = new ClientSyncJob("Session startup", clientSession){

                            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                DefaultTestClientSessionProvider.this.beforeStartSession(this.getClientSession(), runAs);
                                1.getCurrentSession().startSession(bundle);
                                DefaultTestClientSessionProvider.this.simulateDesktopOpened(this.getClientSession());
                                DefaultTestClientSessionProvider.this.afterStartSession(this.getClientSession(), runAs);
                            }
                        };
                        job.schedule();
                        job.join();
                        job.throwOnError();
                    }
                    catch (Throwable t) {
                        LOG.error("could not load session for " + symbolicName, t);
                    }
                }
                return (T)clientSession;
            }
        }
        return null;
    }

    protected String createSessionCacheKey(Class<? extends IClientSession> sessionClass, Bundle providingBundle, String runAs) {
        return StringUtility.join((String)"-", (Object[])new Object[]{providingBundle.getSymbolicName(), runAs});
    }

    protected void beforeStartSession(IClientSession clientSession, String runAs) {
        MultiClientAuthenticator.assignSessionToUser(clientSession, runAs);
        TestingUtility.clearHttpAuthenticationCache();
        clientSession.getVirtualDesktop().addDesktopListener(new DesktopListener(){

            public void desktopChanged(DesktopEvent e) {
                switch (e.getType()) {
                    case 700: {
                        e.getMessageBox().getUIFacade().setResultFromUI(2);
                    }
                }
            }
        });
    }

    protected void afterStartSession(IClientSession clientSession, String runAs) {
    }

    protected void simulateDesktopOpened(IClientSession clientSession) {
        IDesktop desktop = clientSession.getDesktop();
        if (desktop instanceof AbstractDesktop && !desktop.isOpened()) {
            desktop.getUIFacade().fireGuiAttached();
            desktop.getUIFacade().fireDesktopOpenedFromUI();
        }
    }
}

