/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.templates;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.server.DefaultTransactionDelegate;
import org.eclipse.scout.rt.shared.Activator;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.rt.shared.validate.InputValidation;
import org.eclipse.scout.rt.testing.server.runner.ScoutServerTestRunner;
import org.eclipse.scout.service.ServiceUtility;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@RunWith(value=ScoutServerTestRunner.class)
public abstract class AbstractInputValidationStrategyTest {
    private Set<String> m_sharedBundles;
    private Set<String> m_serverBundles;

    protected abstract String[] getConfiguredSharedBundles();

    protected abstract String[] getConfiguredServerBundles();

    @Before
    public void init() {
        this.m_sharedBundles = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.getConfiguredSharedBundles())));
        this.m_serverBundles = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.getConfiguredServerBundles())));
    }

    protected Set<String> getSharedBundles() {
        return this.m_sharedBundles;
    }

    protected Set<String> getServerBundles() {
        return this.m_serverBundles;
    }

    @Test
    public void validateServices() throws Exception {
        ServiceReference[] serviceRefs;
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        HashSet<Method> collector = new HashSet<Method>();
        ServiceReference[] serviceReferenceArray = serviceRefs = context.getAllServiceReferences(null, null);
        int n = serviceRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            Object service = context.getService(ref);
            if (service == null) {
                throw new Exception("Service is null. Test started too early or some services failed to initialize.");
            }
            Class<?> serviceClass = service.getClass();
            if (!Proxy.isProxyClass(serviceClass) && this.fromBundles(serviceClass, this.getServerBundles())) {
                this.checkServiceClass(serviceClass, collector);
            }
            ++n2;
        }
        this.report(collector);
    }

    protected void checkServiceClass(Class<?> serviceClass, Set<Method> collector) throws Exception {
        ArrayList interfacesHierarchy = new ArrayList();
        GenericDeclaration[] genericDeclarationArray = ServiceUtility.getInterfacesHierarchy(serviceClass, Object.class);
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class ci = genericDeclarationArray[n2];
            if (this.fromBundles(ci, this.getSharedBundles())) {
                interfacesHierarchy.add(ci);
            }
            ++n2;
        }
        genericDeclarationArray = serviceClass.getDeclaredMethods();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration m = genericDeclarationArray[n2];
            if (((Method)m).getParameterTypes().length != 0 && Modifier.isPublic(((Method)m).getModifiers()) && !this.hasStrategyByPolicy((Method)m)) {
                this.checkStrategyByAnnotation(serviceClass, interfacesHierarchy, (Method)m, collector);
            }
            ++n2;
        }
    }

    protected boolean hasStrategyByPolicy(Method m) throws Exception {
        String name = m.getName();
        return DefaultTransactionDelegate.DEFAULT_QUERY_NAMES_PATTERN.matcher(name).matches() || DefaultTransactionDelegate.DEFAULT_PROCESS_NAMES_PATTERN.matcher(name).matches();
    }

    protected void checkStrategyByAnnotation(Class<?> serviceClass, Collection<Class<?>> interfacesHierarchy, Method base, Set<Method> collector) throws Exception {
        Class<?> c = serviceClass;
        while (c != null) {
            if (c.getAnnotation(RemoteServiceAccessDenied.class) != null || c.getAnnotation(InputValidation.class) != null) {
                return;
            }
            try {
                Method m = c.getDeclaredMethod(base.getName(), base.getParameterTypes());
                if (m.getAnnotation(InputValidation.class) != null || m.getAnnotation(RemoteServiceAccessDenied.class) != null) {
                    return;
                }
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        for (Class<?> ci : interfacesHierarchy) {
            if (ci.getAnnotation(RemoteServiceAccessDenied.class) != null || ci.getAnnotation(InputValidation.class) != null) continue;
            try {
                Method m = ci.getDeclaredMethod(base.getName(), base.getParameterTypes());
                if (m.getAnnotation(RemoteServiceAccessDenied.class) != null || m.getAnnotation(InputValidation.class) != null) continue;
                collector.add(m);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    protected boolean fromBundles(Class<?> c, Set<String> bundles) {
        Bundle interfaceBundle = FrameworkUtil.getBundle(c);
        return interfaceBundle != null && bundles.contains(interfaceBundle.getSymbolicName());
    }

    protected void report(Set<Method> collector) throws Exception {
        if (!collector.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Method m : collector) {
                builder.append("\n");
                builder.append(m.getDeclaringClass().getName());
                builder.append(".");
                builder.append(m.getName());
            }
            throw new Exception("Missing validation strategy on: " + builder.toString());
        }
    }
}

