/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.prefs.UserScope;
import org.eclipse.scout.rt.testing.shared.JUnitTestClassBrowser;

public class ScoutJUnitPluginTestExecutor {
    private static final String DUMMY_TESTSUITE_NAME = "FRAMEWORK.INIT";
    public static final String JUNIT_REPORTS_DIR_ARG_NAME = "junitReportsDir";
    public static final String FAIL_ON_ERROR_ARG_NAME = "failOnError";
    public static final String HALT_ON_FAILURE_ARG_NAME = "haltOnFailure";
    public static final String BUNDLE_NAME_INCLUDE_FILTER_ARG_NAME = "bundleNameIncludeFilter";
    public static final String BUNDLE_NAME_EXCLUDE_FILTER_ARG_NAME = "bundleNameExcludeFilter";
    public static final String CLASS_NAME_INCLUDE_FILTER_ARG_NAME = "classNameIncludeFilter";
    public static final String CLASS_NAME_EXCLUDE_FILTER_ARG_NAME = "classNameExcludeFilter";
    public static final Integer EXIT_CODE_OK = IApplication.EXIT_OK;
    public static final Integer EXIT_CODE_TESTS_FAILED = 1;
    public static final Integer EXIT_CODE_ERRORS_OCCURRED = 2;
    private final String m_reportsDir;
    private final boolean m_failOnError;
    private final boolean m_haltOnFailure;
    private final Pattern[] m_bundleNameIncludePatterns;
    private final Pattern[] m_bundleNameExcludePatterns;
    private final Pattern[] m_classNameIncludePatterns;
    private final Pattern[] m_classNameExcludePatterns;
    private final String m_launchingProductId;

    public ScoutJUnitPluginTestExecutor() {
        this(ScoutJUnitPluginTestExecutor.getReportsDirConfigParameter(), ScoutJUnitPluginTestExecutor.getFailOnErrorConfigParameter(), ScoutJUnitPluginTestExecutor.getHaltOnFailureConfigParameter(), ScoutJUnitPluginTestExecutor.getBundleNameIncludePatternsConfigParameter(), ScoutJUnitPluginTestExecutor.getBundleNameExcludePatternsConfigParameter(), ScoutJUnitPluginTestExecutor.getClassNameIncludePatternsConfigParameter(), ScoutJUnitPluginTestExecutor.getClassNameExcludePatternsConfigParameter());
    }

    public ScoutJUnitPluginTestExecutor(String reportsDir, boolean failOnError, boolean haltOnFailure, Pattern[] bundleNameIncludePatterns, Pattern[] bundleNameExcludePatterns, Pattern[] classNameIncludePatterns, Pattern[] classNameExcludePatterns) {
        this.m_failOnError = failOnError;
        this.m_haltOnFailure = haltOnFailure;
        this.m_bundleNameIncludePatterns = bundleNameIncludePatterns;
        this.m_bundleNameExcludePatterns = bundleNameExcludePatterns;
        this.m_classNameIncludePatterns = classNameIncludePatterns;
        this.m_classNameExcludePatterns = classNameExcludePatterns;
        if (reportsDir == null) {
            if (Platform.inDevelopmentMode()) {
                String s = System.getenv("APPDATA");
                if (s == null) {
                    s = System.getProperty("user.home");
                }
                reportsDir = String.valueOf(s) + File.separator + "junit-james";
                System.out.println("In -dev mode: junitReportsDir defaults to " + reportsDir);
            } else {
                throw new IllegalArgumentException("junitReportsDir must not be null; check if argument 'junitReportsDir' is set");
            }
        }
        this.m_reportsDir = reportsDir;
        ScoutJUnitPluginTestExecutor.checkAndCreateReportsDir(this.m_reportsDir);
        String productId = null;
        if (Platform.getProduct() != null) {
            productId = Platform.getProduct().getId();
        }
        this.m_launchingProductId = productId;
    }

    private static String getConfigParameter(String parameterName) {
        String commandLineArgumentName = "-" + parameterName + "=";
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg != null && arg.startsWith(commandLineArgumentName)) {
                return arg.substring(commandLineArgumentName.length());
            }
            ++n2;
        }
        return System.getProperty(parameterName);
    }

    private static String getReportsDirConfigParameter() {
        return ScoutJUnitPluginTestExecutor.getConfigParameter(JUNIT_REPORTS_DIR_ARG_NAME);
    }

    private static void checkAndCreateReportsDir(String reportsDir) {
        File repDir = new File(reportsDir);
        if (repDir.exists() && repDir.isFile()) {
            throw new IllegalArgumentException("the given reports directory already exists and it is a file");
        }
        repDir.mkdirs();
    }

    private static Pattern[] getBundleNameIncludePatternsConfigParameter() {
        return JUnitTestClassBrowser.parseFilterPatterns(ScoutJUnitPluginTestExecutor.getConfigParameter(BUNDLE_NAME_INCLUDE_FILTER_ARG_NAME));
    }

    private static Pattern[] getBundleNameExcludePatternsConfigParameter() {
        return JUnitTestClassBrowser.parseFilterPatterns(ScoutJUnitPluginTestExecutor.getConfigParameter(BUNDLE_NAME_EXCLUDE_FILTER_ARG_NAME));
    }

    private static Pattern[] getClassNameIncludePatternsConfigParameter() {
        return JUnitTestClassBrowser.parseFilterPatterns(ScoutJUnitPluginTestExecutor.getConfigParameter(CLASS_NAME_INCLUDE_FILTER_ARG_NAME));
    }

    private static Pattern[] getClassNameExcludePatternsConfigParameter() {
        return JUnitTestClassBrowser.parseFilterPatterns(ScoutJUnitPluginTestExecutor.getConfigParameter(CLASS_NAME_EXCLUDE_FILTER_ARG_NAME));
    }

    private static boolean getFailOnErrorConfigParameter() {
        return (Boolean)TypeCastUtility.castValue((Object)ScoutJUnitPluginTestExecutor.getConfigParameter(FAIL_ON_ERROR_ARG_NAME), Boolean.TYPE);
    }

    private static boolean getHaltOnFailureConfigParameter() {
        return (Boolean)TypeCastUtility.castValue((Object)ScoutJUnitPluginTestExecutor.getConfigParameter(HALT_ON_FAILURE_ARG_NAME), Boolean.TYPE);
    }

    public boolean isFailOnError() {
        return this.m_failOnError;
    }

    public boolean isHaltOnFailure() {
        return this.m_haltOnFailure;
    }

    public String getReportsDir() {
        return this.m_reportsDir;
    }

    public int runAllTests() {
        int exitCode = EXIT_CODE_OK;
        try {
            JUnitTestClassBrowser browser = new JUnitTestClassBrowser();
            browser.setBundleNameIncludePatterns(this.m_bundleNameIncludePatterns);
            browser.setBundleNameExcludePatterns(this.m_bundleNameExcludePatterns);
            browser.setClassNameIncludePatterns(this.m_classNameIncludePatterns);
            browser.setClassNameExcludePatterns(this.m_classNameExcludePatterns);
            for (Class<?> test : browser.collectAllJUnitTestClasses()) {
                int testResultCode = this.runTest(test);
                exitCode = Math.max(exitCode, testResultCode);
                if (!this.isHaltOnFailure() || exitCode == EXIT_CODE_OK) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            try {
                XMLJUnitResultFormatter formatter = this.createJUnitResultFormatter(DUMMY_TESTSUITE_NAME);
                JUnitTest dummyTest = new JUnitTest(DUMMY_TESTSUITE_NAME);
                formatter.startTestSuite(dummyTest);
                formatter.addError(null, t);
                formatter.endTestSuite(dummyTest);
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
            exitCode = EXIT_CODE_ERRORS_OCCURRED;
        }
        if (this.isFailOnError()) {
            return exitCode;
        }
        return EXIT_CODE_OK;
    }

    public int runTest(Class<?> testClass) throws FileNotFoundException {
        int result;
        block27: {
            result = EXIT_CODE_OK;
            try {
                new UserScope().getNode("org.eclipse.scout.rt.client").clear();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            PrintStream sysOut = null;
            PrintStream sysErr = null;
            PrintStream oldSysOut = System.out;
            PrintStream oldSysErr = System.err;
            if (Platform.inDevelopmentMode()) {
                System.out.println(this.getFileNameFor(testClass.getName()));
            }
            try {
                ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
                sysOut = new PrintStream(outStrm);
                ByteArrayOutputStream errStrm = new ByteArrayOutputStream();
                sysErr = new PrintStream(errStrm);
                if (!Platform.inDevelopmentMode()) {
                    System.setOut(sysOut);
                    System.setErr(sysErr);
                }
                JUnitTest junitTest = this.createJUnitTest(testClass.getName());
                XMLJUnitResultFormatter formatter = this.createJUnitResultFormatter(testClass.getName());
                long start = System.currentTimeMillis();
                formatter.startTestSuite(junitTest);
                TestResult testResult = new TestResult();
                testResult.addListener((TestListener)formatter);
                try {
                    try {
                        new JUnit4TestAdapter(testClass).run(testResult);
                    }
                    catch (Throwable t) {
                        formatter.addError(null, t);
                        result = EXIT_CODE_ERRORS_OCCURRED;
                        formatter.setSystemOutput(new String(outStrm.toByteArray()));
                        formatter.setSystemError(new String(errStrm.toByteArray()));
                        junitTest.setCounts((long)testResult.runCount(), (long)testResult.failureCount(), (long)testResult.errorCount());
                        junitTest.setRunTime(System.currentTimeMillis() - start);
                        formatter.endTestSuite(junitTest);
                        if (result == EXIT_CODE_OK) {
                            if (testResult.errorCount() > 0) {
                                result = EXIT_CODE_ERRORS_OCCURRED;
                            } else if (testResult.failureCount() > 0) {
                                result = EXIT_CODE_TESTS_FAILED;
                            }
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    formatter.setSystemOutput(new String(outStrm.toByteArray()));
                    formatter.setSystemError(new String(errStrm.toByteArray()));
                    junitTest.setCounts((long)testResult.runCount(), (long)testResult.failureCount(), (long)testResult.errorCount());
                    junitTest.setRunTime(System.currentTimeMillis() - start);
                    formatter.endTestSuite(junitTest);
                    if (result == EXIT_CODE_OK) {
                        if (testResult.errorCount() > 0) {
                            result = EXIT_CODE_ERRORS_OCCURRED;
                        } else if (testResult.failureCount() > 0) {
                            result = EXIT_CODE_TESTS_FAILED;
                        }
                    }
                    throw throwable;
                }
                formatter.setSystemOutput(new String(outStrm.toByteArray()));
                formatter.setSystemError(new String(errStrm.toByteArray()));
                junitTest.setCounts((long)testResult.runCount(), (long)testResult.failureCount(), (long)testResult.errorCount());
                junitTest.setRunTime(System.currentTimeMillis() - start);
                formatter.endTestSuite(junitTest);
                if (result == EXIT_CODE_OK) {
                    if (testResult.errorCount() > 0) {
                        result = EXIT_CODE_ERRORS_OCCURRED;
                    } else if (testResult.failureCount() > 0) {
                        result = EXIT_CODE_TESTS_FAILED;
                    }
                }
            }
            finally {
                if (sysOut != null) {
                    sysOut.close();
                    sysOut = null;
                }
                if (sysErr != null) {
                    sysErr.close();
                    sysErr = null;
                }
                System.setOut(oldSysOut);
                System.setErr(oldSysErr);
            }
        }
        if (Platform.inDevelopmentMode()) {
            this.dumpResult(new File(String.valueOf(this.getReportsDir()) + File.separator + this.getFileNameFor(testClass.getName())), result);
        }
        return result;
    }

    private JUnitTest createJUnitTest(String testName) {
        JUnitTest junitTest = new JUnitTest(StringUtility.join((String)"-", (Object[])new Object[]{this.m_launchingProductId, testName}));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        junitTest.setProperties((Hashtable)props);
        return junitTest;
    }

    private XMLJUnitResultFormatter createJUnitResultFormatter(String testName) throws FileNotFoundException {
        XMLJUnitResultFormatter formatter = new XMLJUnitResultFormatter();
        formatter.setOutput((OutputStream)new FileOutputStream(String.valueOf(this.getReportsDir()) + File.separator + this.getFileNameFor(testName)));
        return formatter;
    }

    private String getFileNameFor(String testName) throws FileNotFoundException {
        if (this.m_launchingProductId != null) {
            return "TEST-" + this.m_launchingProductId + "-" + testName + ".xml";
        }
        return "TEST-" + testName + ".xml";
    }

    private void dumpResult(File f, int exitCode) {
        if (f.isFile() && exitCode != EXIT_CODE_OK) {
            System.out.println("FAILED " + f.getName());
            try {
                FileInputStream in = new FileInputStream(f);
                byte[] buf = new byte[(int)f.length()];
                in.read(buf);
                in.close();
                System.out.println(new String(buf, 0, buf.length));
            }
            catch (Throwable t) {
                System.out.println("ERROR: " + t);
            }
            if (this.isHaltOnFailure()) {
                System.exit(exitCode);
            }
        }
    }
}

