/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;

public class ButtonMenuArrowDownIcon
implements Icon {
    private static final Map<IconGroup.IconState, Color> ARROW_COLOR_MAP = new HashMap<IconGroup.IconState, Color>();
    private Insets m_insets;
    private IconGroup.IconState m_state;

    public ButtonMenuArrowDownIcon(Insets insets, IconGroup.IconState state) {
        ARROW_COLOR_MAP.put(IconGroup.IconState.NORMAL, UIManager.getColor("ButtonArrow.normal"));
        ARROW_COLOR_MAP.put(IconGroup.IconState.DISABLED, UIManager.getColor("ButtonArrow.disabled"));
        ARROW_COLOR_MAP.put(IconGroup.IconState.ROLLOVER, UIManager.getColor("ButtonArrow.mouseOver"));
        this.m_insets = insets;
        this.m_state = state;
    }

    @Override
    public int getIconWidth() {
        int width = 5;
        if (this.getInsets() != null) {
            width += this.getInsets().left;
            width += this.getInsets().right;
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        int height = 3;
        if (this.getInsets() != null) {
            height += this.getInsets().top + this.getInsets().bottom;
        }
        return height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int arrowHeight = 3;
        int startAtX = x;
        int startAtY = y;
        if (this.getInsets() != null) {
            startAtX += this.getInsets().left;
            startAtY += this.getInsets().top;
        }
        g.setColor(ARROW_COLOR_MAP.get((Object)this.m_state));
        int j = 0;
        while (j < arrowHeight) {
            int arrowWidth = this.calcArrowWidth(j);
            int ax = startAtX + j;
            int ay = startAtY + j;
            g.drawLine(ax, ay, ax + arrowWidth - 1, ay);
            ++j;
        }
    }

    private int calcArrowWidth(int line) {
        return 5 - line * 2;
    }

    public Insets getInsets() {
        return this.m_insets;
    }

    public static IconGroup createMenuArrowDownIconGroup(Insets insets) {
        IconGroup group = new IconGroup();
        group.setIcon(IconGroup.IconState.NORMAL, new ButtonMenuArrowDownIcon(insets, IconGroup.IconState.NORMAL));
        group.setIcon(IconGroup.IconState.ROLLOVER, new ButtonMenuArrowDownIcon(insets, IconGroup.IconState.ROLLOVER));
        group.setIcon(IconGroup.IconState.DISABLED, new ButtonMenuArrowDownIcon(insets, IconGroup.IconState.DISABLED));
        return group;
    }
}

