/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JButtonEx
extends JButton {
    private static final long serialVersionUID = 1L;
    private boolean m_actionOnMousePressed = false;
    private Color m_enabledBackgroundColor;
    private Color m_disabledBackgroundColor;

    public JButtonEx(Action a) {
        this();
        this.setAction(a);
    }

    public JButtonEx() {
        SwingUtility.installDefaultFocusHandling(this);
        this.addMouseListener(new P_MouseListener());
    }

    public boolean isActionOnMousePressed() {
        return this.m_actionOnMousePressed;
    }

    public void setActionOnMousePressed(boolean b) {
        this.m_actionOnMousePressed = b;
    }

    @Override
    public void setBackground(Color bg) {
        Color cc;
        this.m_enabledBackgroundColor = bg;
        this.m_disabledBackgroundColor = null;
        if (bg != null && (cc = UIManager.getColor("control")) != null) {
            this.m_disabledBackgroundColor = new ColorUIResource(new Color((bg.getRed() + cc.getRed()) / 2, (bg.getGreen() + cc.getGreen()) / 2, (bg.getBlue() + cc.getBlue()) / 2));
        }
        super.setBackground(bg);
    }

    @Override
    public void setEnabled(boolean b) {
        boolean changed = this.isEnabled() ^ b;
        super.setEnabled(b);
        if (changed) {
            if (b) {
                if (this.m_enabledBackgroundColor != null) {
                    super.setBackground(this.m_enabledBackgroundColor);
                }
            } else if (this.m_disabledBackgroundColor != null) {
                super.setBackground(this.m_disabledBackgroundColor);
            }
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }

    private class P_MouseListener
    extends MouseAdapter {
        private P_MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger() && JButtonEx.this.isActionOnMousePressed()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            1.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Runnable t = new Runnable(){

                            @Override
                            public void run() {
                                ButtonModel m = JButtonEx.this.getModel();
                                if (m != null && m.isPressed()) {
                                    m.setPressed(false);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(t);
                    }
                }.start();
            }
        }
    }
}

