/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class WizardStatusButton
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int HEIGHT = 42;
    private static final int MIN_WIDTH = 160;
    private String m_index;
    private String m_text;
    private boolean m_selected;

    public WizardStatusButton() {
        this.setBorder(new EmptyBorder(3, 10, 3, 10));
        this.setMaximumSize(new Dimension(10240, 42));
        this.setForeground(new Color(1183608));
    }

    public String getIndex() {
        return this.m_index;
    }

    public void setIndex(String index) {
        this.m_index = index;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(10240, 10240);
    }

    @Override
    public Dimension getPreferredSize() {
        int w = 160;
        if (this.m_text != null) {
            int textWidth = this.getFontMetrics(this.getFont()).stringWidth(this.m_text);
            Insets insets = this.getInsets();
            w = Math.max(insets.left + insets.right + 42 + 6 + textWidth, 160);
        }
        return new Dimension(w, 42);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right - 1;
        int h = this.getHeight() - insets.top - insets.bottom - 1;
        try {
            g.translate(insets.left, insets.top);
            if (this.isSelected()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(16771535), w, 0.0f, new Color(16756813)));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x9CCCD9), w, 0.0f, new Color(4103348)));
            }
            g2.fillRoundRect(0, 0, w, h, h, h);
            if (this.isSelected()) {
                g2.setPaint(new Color(16756813));
            } else {
                g2.setPaint(new Color(233129));
            }
            g2.drawRoundRect(0, 0, w, h, h, h);
            if (this.isSelected()) {
                g2.setPaint(new Color(16756813));
            } else {
                g2.setPaint(new Color(233129));
            }
            g2.fillRoundRect(0, 0, h, h, h, h);
            if (this.isSelected()) {
                g2.setPaint(new Color(16755264));
            } else {
                g2.setPaint(new Color(754336));
            }
            g2.drawRoundRect(0, 0, h, h, h, h);
            FontMetrics fm = g.getFontMetrics();
            int baseline = h / 2 + fm.getAscent() / 2;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (this.isSelected()) {
                g2.setPaint(new Color(0));
            } else {
                g2.setPaint(new Color(0xFFFFFF));
            }
            if (this.m_index != null) {
                g2.drawString(this.m_index, (h - fm.stringWidth(this.m_index)) / 2 + 1, baseline);
            }
            if (this.m_text != null) {
                g2.drawString(this.m_text, h + 6, baseline);
            }
        }
        finally {
            g.translate(-insets.left, -insets.top);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

