/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class SmallCalendarLayout
implements LayoutManager2 {
    private DateChooser m_dateChooser;
    private Dimension m_prefSize;
    private Dimension m_cellSize;

    public SmallCalendarLayout(DateChooser dateChooser) {
        this.m_dateChooser = dateChooser;
        this.m_prefSize = this.calcPreferredSize();
        this.m_cellSize = this.getGridCellSize();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.m_prefSize);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(this.m_prefSize);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.m_prefSize);
    }

    @Override
    public void layoutContainer(Container parent) {
        int x = 0;
        int y = 0;
        int w = this.m_prefSize.width;
        int cellW = this.m_cellSize.width;
        int cellH = this.m_cellSize.height;
        JPanel headerPanel = this.m_dateChooser.getHeaderPanel();
        headerPanel.setBounds(x, y, w, cellH);
        JPanel daysPanel = this.m_dateChooser.getDaysPanel();
        daysPanel.setBounds(x, y += cellH, cellW * 7, cellH);
        this.m_dateChooser.getCellsPanel().setBounds(x, y += cellH, w, 6 * cellH);
    }

    private Dimension calcPreferredSize() {
        Dimension gridCellSize = this.getGridCellSize();
        int numRows = 8;
        int numHorizontalLines = numRows - 1;
        int columns = 7;
        int height = numRows * gridCellSize.height + numHorizontalLines;
        int width = columns * gridCellSize.width;
        return new Dimension(width, height);
    }

    private Dimension getGridCellSize() {
        Dimension dim = UIManager.getDimension("Calendar.gridCellSize");
        if (dim == null) {
            dim = new Dimension(23, 23);
        }
        return dim;
    }
}

