/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.ext.decoration.AbstractDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationMouseEvent;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecorationGroup;

public class DecorationGroup
extends AbstractDecoration
implements IDecorationGroup {
    private final List<IDecoration> m_decorations = new ArrayList<IDecoration>(3);

    public DecorationGroup(JComponent owner, ISwingEnvironment environment) {
        super(owner, environment, true);
    }

    @Override
    public void addDecoration(IDecoration icon) {
        this.m_decorations.add(icon);
    }

    @Override
    public boolean removeDecoration(IDecoration icon) {
        return this.m_decorations.remove(icon);
    }

    @Override
    public List<IDecoration> getDecoration() {
        return CollectionUtility.arrayList(this.m_decorations);
    }

    @Override
    protected Rectangle paintInternal(Component c, Graphics g, int x, int y) {
        int height = 0;
        int width = 0;
        int iconX = x;
        for (IDecoration child : this.m_decorations) {
            int childWidth = child.getWidth();
            child.paint(c, g, iconX, y);
            iconX += childWidth;
            width += childWidth;
            height = Math.max(child.getHeight(), height);
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (IDecoration child : this.m_decorations) {
            width += child.getWidth();
        }
        return width;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (IDecoration child : this.m_decorations) {
            height = Math.max(child.getHeight(), height);
        }
        return height;
    }

    @Override
    public void handleMouseChlicked(MouseEvent e) {
        for (IDecoration d : this.getDecoration()) {
            if (d.getBounds() == null || !d.getBounds().contains(e.getPoint())) continue;
            d.handleMouseChlicked(e);
            break;
        }
    }

    @Override
    public void handleMouseMoved(DecorationMouseEvent e) {
        for (IDecoration d : this.getDecoration()) {
            d.handleMouseMoved(e);
        }
    }

    @Override
    public void handleMouseExit(DecorationMouseEvent e) {
        for (IDecoration d : this.getDecoration()) {
            d.handleMouseExit(e);
        }
    }
}

