/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.focus;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class SwingScoutFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutFocusTraversalPolicy.class);

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        boolean accept;
        if (aComponent != null && !(accept = SwingUtility.runInputVerifier(aComponent))) {
            return aComponent;
        }
        return this.getComponentAfterV(focusCycleRoot, aComponent);
    }

    private Component getComponentAfterV(Container focusCycleRoot, Component aComponent) {
        if (focusCycleRoot == null || aComponent == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!aComponent.isFocusCycleRoot(focusCycleRoot)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        ArrayList<Component> cycle = new ArrayList<Component>();
        this.enumerateCycle(focusCycleRoot, aComponent, cycle);
        int index = cycle.indexOf(aComponent);
        Component nextComp = null;
        if (index >= 0) {
            nextComp = cycle.get((index + 1) % cycle.size());
        } else if (cycle.size() > 0) {
            nextComp = cycle.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("curr: " + aComponent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("next: " + nextComp);
        }
        return nextComp;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        boolean accept;
        if (aComponent != null && !(accept = SwingUtility.runInputVerifier(aComponent))) {
            return aComponent;
        }
        return this.getComponentBeforeV(focusCycleRoot, aComponent);
    }

    private Component getComponentBeforeV(Container focusCycleRoot, Component aComponent) {
        if (focusCycleRoot == null || aComponent == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!aComponent.isFocusCycleRoot(focusCycleRoot)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        ArrayList<Component> cycle = new ArrayList<Component>();
        this.enumerateCycle(focusCycleRoot, aComponent, cycle);
        int index = cycle.indexOf(aComponent);
        Component prevComp = null;
        if (index >= 0) {
            prevComp = cycle.get((index - 1 + cycle.size()) % cycle.size());
        } else if (cycle.size() > 0) {
            prevComp = cycle.get(cycle.size() - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("curr: " + aComponent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("prev: " + prevComp);
        }
        return prevComp;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getDefaultComponentV(focusCycleRoot);
    }

    private Component getDefaultComponentV(Container focusCycleRoot) {
        return this.getFirstComponentV(focusCycleRoot);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return this.getFirstComponentV(focusCycleRoot);
    }

    private Component getFirstComponentV(Container focusCycleRoot) {
        if (focusCycleRoot == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        ArrayList<Component> cycle = new ArrayList<Component>();
        this.enumerateCycle(focusCycleRoot, null, cycle);
        if (cycle.size() > 0) {
            return cycle.get(0);
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return this.getLastComponentV(focusCycleRoot);
    }

    private Component getLastComponentV(Container focusCycleRoot) {
        if (focusCycleRoot == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        ArrayList<Component> cycle = new ArrayList<Component>();
        this.enumerateCycle(focusCycleRoot, null, cycle);
        if (cycle.size() > 0) {
            return cycle.get(cycle.size() - 1);
        }
        return null;
    }

    private void enumerateCycle(Container focusCycleRoot, Component currentOwner, List<Component> cycle) {
        this.enumerateCycleRec(focusCycleRoot, currentOwner, cycle);
    }

    private void enumerateCycleRec(Container container, Component currentOwner, List<Component> cycle) {
        if (container == currentOwner || this.accept(container)) {
            cycle.add(container);
        }
        Component[] components = container.getComponents();
        int i = 0;
        while (i < components.length) {
            Component comp = components[i];
            if (comp instanceof Container) {
                this.enumerateCycleRec((Container)comp, currentOwner, cycle);
            } else if (comp == currentOwner || this.accept(comp)) {
                cycle.add(comp);
            }
            ++i;
        }
    }

    public boolean accept(Component comp) {
        if (!(comp.isVisible() && comp.isFocusable() && comp.isEnabled())) {
            return false;
        }
        if (!(comp instanceof Window)) {
            Container test = comp.getParent();
            while (test != null) {
                if (!test.isVisible()) {
                    return false;
                }
                if (!test.isEnabled() && !test.isLightweight()) {
                    return false;
                }
                if (test instanceof Window) break;
                test = test.getParent();
            }
        }
        if (comp.isDisplayable() && !comp.isLightweight()) {
            return comp instanceof Canvas;
        }
        if (comp instanceof JScrollBar) {
            return false;
        }
        if (comp instanceof JPanel) {
            return false;
        }
        if (comp instanceof BasicSplitPaneDivider) {
            return false;
        }
        if (comp instanceof JInternalFrame) {
            return false;
        }
        if (comp instanceof JTextComponent && !((JTextComponent)comp).isEditable()) {
            return false;
        }
        JTabbedPane tabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, comp);
        if (tabbedPane != null && !SwingUtilities.isDescendingFrom(comp, tabbedPane.getSelectedComponent())) {
            return false;
        }
        if (comp instanceof JTable) {
            return true;
        }
        if (comp instanceof JComboBox) {
            return true;
        }
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            InputMap inputMap = jcomp.getInputMap(0);
            while (inputMap != null && inputMap.size() == 0) {
                inputMap = inputMap.getParent();
            }
            if (inputMap == null) {
                return false;
            }
        }
        return true;
    }
}

