/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.tabbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.ISwingScoutGroupBox;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabItem;

public class SwingScoutTabItem
extends SwingScoutComposite<IGroupBox>
implements ISwingScoutTabItem {
    private Icon m_swingTabIcon;
    private ISwingScoutGroupBox m_groupBoxComposite;
    private static final Color FOREGROUND = UIManager.getColor("TabItem.foreground");
    private static final Color SELECTED = UIManager.getColor("TabItem.selected.foreground");
    private static final Color DISABLED = UIManager.getColor("TabItem.disabledText");

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_groupBoxComposite = (ISwingScoutGroupBox)this.getSwingEnvironment().createFormField(null, (IFormField)this.getScoutObject());
        this.m_swingTabIcon = this.createSwingTabIcon();
        this.setSwingField(this.m_groupBoxComposite.getSwingContainer());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IGroupBox scoutField = (IGroupBox)this.getScoutObject();
        if (scoutField != null) {
            this.setSaveNeededFromScout();
            this.setEmptyFromScout();
            this.setLabelFromScout();
            this.setFontFromScout();
        }
    }

    protected SwingTabIcon createSwingTabIcon() {
        return new SwingTabIcon();
    }

    @Override
    public Icon getSwingTabIcon() {
        return this.m_swingTabIcon;
    }

    @Override
    public ISwingScoutGroupBox getGroupBoxComposite() {
        return this.m_groupBoxComposite;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("empty".equals(name)) {
            this.setEmptyFromScout();
        } else if ("saveNeeded".equals(name)) {
            this.setSaveNeededFromScout();
        } else if ("label".equals(name)) {
            this.setLabelFromScout();
        } else if ("font".equals(name)) {
            this.setFontFromScout();
        }
    }

    protected void setSaveNeededFromScout() {
        boolean updateMarker = false;
        if (((IGroupBox)this.getScoutObject()).getParentField() instanceof ITabBox) {
            if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 1) {
                updateMarker = true;
            }
        } else if (((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm) {
            updateMarker = true;
        }
        if (updateMarker) {
            if (this.getSwingTabIcon() instanceof SwingTabIcon) {
                ((SwingTabIcon)this.getSwingTabIcon()).setMarked(((IGroupBox)this.getScoutObject()).isSaveNeeded());
            }
            this.repaintSwingTabbedPane();
        }
    }

    protected void setEmptyFromScout() {
        boolean updateMarker = false;
        if (((IGroupBox)this.getScoutObject()).getParentField() instanceof ITabBox) {
            if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 0) {
                updateMarker = true;
            }
        } else if (!(((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm)) {
            updateMarker = true;
        }
        if (updateMarker) {
            if (this.getSwingTabIcon() instanceof SwingTabIcon) {
                ((SwingTabIcon)this.getSwingTabIcon()).setMarked(!((IGroupBox)this.getScoutObject()).isEmpty());
            }
            this.repaintSwingTabbedPane();
        }
    }

    protected void setLabelFromScout() {
        if (this.getSwingTabIcon() instanceof SwingTabIcon) {
            String s = ((IGroupBox)this.getScoutObject()).getLabel();
            if (s == null) {
                s = "";
            }
            String label = StringUtility.removeMnemonic((String)s);
            ((SwingTabIcon)this.getSwingTabIcon()).setText(label);
        }
        this.repaintSwingTabbedPane();
    }

    protected void setFontFromScout() {
        this.repaintSwingTabbedPane();
    }

    private void repaintSwingTabbedPane() {
        JTabbedPane parent = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, this.getSwingContainer());
        if (parent != null) {
            parent.revalidate();
            parent.repaint();
        }
    }

    public class SwingTabIcon
    implements Icon {
        private static final int TEXT_ICON_GAP = 2;
        private Insets m_insets;
        private String m_text = "";
        private boolean m_marked = false;
        private boolean m_selected = false;
        private Color m_markerColor = new Color(16755264);
        private Icon m_markerIcon;

        public SwingTabIcon() {
            this.m_insets = UIManager.getInsets("TabbedPane.tabAreaInsets");
            if (this.m_insets == null) {
                this.m_insets = new Insets(0, 0, 0, 0);
            }
        }

        public void setText(String s) {
            this.m_text = s != null ? s : "";
        }

        public String getText() {
            return this.m_text;
        }

        public void setMarked(boolean b) {
            this.m_marked = b;
        }

        public boolean isMarked() {
            return this.m_marked;
        }

        public void setMarkerIcon(Icon icon) {
            this.m_markerIcon = icon;
        }

        public Icon getMarkerIcon() {
            return this.m_markerIcon;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        @Override
        public int getIconWidth() {
            Font f = SwingScoutTabItem.this.getSwingContainer().getFont();
            if (f != null) {
                int w = SwingScoutTabItem.this.getSwingContainer().getFontMetrics(f).stringWidth(this.m_text);
                if (this.getMarkerIcon() != null) {
                    w += this.isMarked() ? 2 + this.getMarkerIcon().getIconWidth() : 0;
                }
                return w;
            }
            return 100;
        }

        @Override
        public int getIconHeight() {
            Font f = SwingScoutTabItem.this.getSwingContainer().getFont();
            if (f != null) {
                return SwingScoutTabItem.this.getSwingContainer().getFontMetrics(f).getHeight() + this.m_insets.top + this.m_insets.bottom;
            }
            return 16 + this.m_insets.top + this.m_insets.bottom;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Font f = SwingScoutTabItem.this.getSwingContainer().getFont();
            FontMetrics fm = SwingScoutTabItem.this.getSwingContainer().getFontMetrics(f);
            g.setFont(f);
            int baseline = y + this.m_insets.top + fm.getAscent();
            String s = this.m_text;
            if (this.m_marked) {
                int w = fm.stringWidth(s) - 1;
                if (this.getMarkerIcon() != null) {
                    this.getMarkerIcon().paintIcon(c, g, x + w + 2, baseline - this.getMarkerIcon().getIconHeight());
                } else {
                    g.setColor(this.m_markerColor);
                    g.drawLine(x, baseline + 1, x + w, baseline + 1);
                    g.drawLine(x, baseline + 2, x + w, baseline + 2);
                }
            }
            if (!((IGroupBox)SwingScoutTabItem.this.getScoutObject()).isEnabled()) {
                g.setColor(DISABLED);
            } else if (this.m_selected) {
                g.setColor(SELECTED);
            } else {
                g.setColor(FOREGROUND);
            }
            g.drawString(s, x, baseline);
        }
    }
}

