/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.textfield;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellingMonitor;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextAreaEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextAreaWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.ISwingScoutTextArea;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.SwingScoutTextFieldComposite;
import org.eclipse.scout.rt.ui.swing.spellchecker.ISwingSpellCheckerService;
import org.eclipse.scout.rt.ui.swing.spellchecker.SwingFieldHolder;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutTextArea
extends SwingScoutTextFieldComposite<IStringField>
implements ISwingScoutTextArea {
    private JScrollPane m_swingScrollPane;
    private ISpellingMonitor m_spellingMonitor;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;
    private PropertyChangeListener m_contextMenuVisibilityListener;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextAreaWithDecorationIcons textField = new JTextAreaWithDecorationIcons();
        textField.setOpaque(true);
        this.m_contextMenuMarker = new ContextMenuDecorationItem((IContextMenu)((IStringField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutTextArea.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        textField.setDecorationIcon(this.m_contextMenuMarker);
        this.m_swingScrollPane = new JScrollPaneEx(textField);
        this.m_swingScrollPane.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IStringField)this.getScoutObject()).getGridData()));
        container.add(this.m_swingScrollPane);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_swingScrollPane;
    }

    @Override
    public JTextAreaEx getSwingTextArea() {
        return (JTextAreaEx)this.getSwingTextComponent();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTextWrapFromScout(((IStringField)this.getScoutObject()).isWrapText());
        ISwingSpellCheckerService spellCheckerService = (ISwingSpellCheckerService)SERVICES.getService(ISwingSpellCheckerService.class);
        if (spellCheckerService != null && spellCheckerService.isInstalled()) {
            this.m_spellingMonitor = spellCheckerService.createSpellingMonitor(new SwingFieldHolder(this, this.getSwingTextArea()));
        }
        this.installContextMenu();
    }

    @Override
    protected void detachScout() {
        if (this.m_spellingMonitor != null) {
            this.m_spellingMonitor.dispose();
            this.m_spellingMonitor = null;
        }
        this.uninstallContextMenu();
        super.detachScout();
    }

    protected void installContextMenu() {
        this.m_contextMenuVisibilityListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutTextArea.this.m_contextMenuMarker.setMarkerVisible(((IStringField)SwingScoutTextArea.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        };
        ((IStringField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(this.m_contextMenuVisibilityListener);
        this.m_contextMenuMarker.setMarkerVisible(((IStringField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingField(), (IContextMenu)((IStringField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    protected void uninstallContextMenu() {
        if (this.m_contextMenuVisibilityListener != null) {
            ((IStringField)this.getScoutObject()).getContextMenu().removePropertyChangeListener(this.m_contextMenuVisibilityListener);
            this.m_contextMenuVisibilityListener = null;
        }
    }

    @Override
    protected void setKeyStrokesFromScout() {
        super.setKeyStrokesFromScout();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        float swingAlignX = SwingUtility.createAlignmentX(scoutAlign);
        this.getSwingTextArea().setAlignmentX(swingAlignX);
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        float swingAlignY = SwingUtility.createAlignmentY(scoutAlign);
        this.getSwingTextArea().setAlignmentY(swingAlignY);
    }

    protected void setTextWrapFromScout(boolean b) {
        this.getSwingTextArea().setLineWrap(b);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }
}

