/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.internalframe;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JInternalFrameEx;
import org.eclipse.scout.rt.ui.swing.ext.JRootPaneEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutBoundsProvider;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;

public class SwingScoutInternalFrame
implements ISwingScoutView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutInternalFrame.class);
    private final ISwingEnvironment m_env;
    private boolean m_addedToDesktop;
    private final EventListenerList m_listenerList;
    private final JInternalFrameEx m_swingView;
    private final Object m_viewConstraints;
    private boolean m_maximized;
    private ISwingScoutBoundsProvider m_boundsProvider;

    public SwingScoutInternalFrame(ISwingEnvironment env, Object viewConstraints) {
        this(env, viewConstraints, null);
    }

    public SwingScoutInternalFrame(ISwingEnvironment env, Object viewConstraints, ISwingScoutBoundsProvider provider) {
        this.m_env = env;
        this.m_viewConstraints = viewConstraints;
        this.m_boundsProvider = provider;
        this.m_listenerList = new EventListenerList();
        this.m_swingView = new JInternalFrameEx(" ", " ", false, false, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected JRootPane createRootPane() {
                return new JRootPaneEx(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void reflow() {
                        if (SwingScoutInternalFrame.this.m_swingView.getParent() != null && !SwingScoutInternalFrame.this.m_swingView.isIcon()) {
                            ((JComponent)SwingScoutInternalFrame.this.m_swingView.getParent()).revalidate();
                        }
                    }
                };
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                if (SwingScoutInternalFrame.this.m_boundsProvider != null && SwingScoutInternalFrame.this.m_addedToDesktop) {
                    SwingScoutInternalFrame.this.m_boundsProvider.storeBounds(this.getBounds());
                }
            }
        };
        this.m_swingView.setDefaultCloseOperation(0);
        SwingUtility.installFocusCycleRoot(this.m_swingView, new SwingScoutFocusTraversalPolicy());
        JComponent contentPane = (JComponent)this.m_swingView.getContentPane();
        contentPane.setLayout(new BorderLayoutEx());
        contentPane.setCursor(Cursor.getDefaultCursor());
        this.m_swingView.addInternalFrameListener(new P_SwingWindowListener());
        this.m_swingView.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    if (!SwingScoutInternalFrame.this.m_swingView.isSelected()) {
                        SwingScoutInternalFrame.this.m_swingView.setSelected(true);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        if (focusOwner == null || focusOwner instanceof JInternalFrame) {
                            SwingScoutInternalFrame.this.m_swingView.getContentPane().transferFocus();
                        }
                    }
                });
            }
        });
        this.m_swingView.pack();
    }

    public JInternalFrame getSwingInternalFrame() {
        return this.m_swingView;
    }

    @Override
    public JComponent getSwingContentPane() {
        return (JComponent)this.m_swingView.getContentPane();
    }

    @Override
    public void addSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.add(SwingScoutViewListener.class, (EventListener)listener);
    }

    @Override
    public void removeSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.remove(SwingScoutViewListener.class, (EventListener)listener);
    }

    private void fireSwingScoutViewEvent(SwingScoutViewEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(SwingScoutViewListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((SwingScoutViewListener)listeners[i]).viewChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_addedToDesktop;
    }

    @Override
    public boolean isActive() {
        return this.m_swingView != null && this.m_swingView.isSelected();
    }

    public void setBoundsProvider(ISwingScoutBoundsProvider boundsProvider) {
        this.m_boundsProvider = boundsProvider;
    }

    @Override
    public void openView() {
        this.m_env.getRootComposite().getDesktopComposite().addView(this.m_swingView, this.m_viewConstraints);
        if (this.m_boundsProvider != null) {
            Rectangle c = this.m_boundsProvider.getBounds();
            if (c != null) {
                this.m_env.getRootComposite().getDesktopComposite().getSwingDesktopPane().getDesktopManager().resizeFrame(this.m_swingView, c.x, c.y, c.width, c.height);
            }
            this.m_boundsProvider.storeBounds(this.m_swingView.getBounds());
        }
        this.m_addedToDesktop = true;
    }

    @Override
    public void closeView() {
        if (this.m_boundsProvider != null) {
            this.m_boundsProvider.storeBounds(this.m_swingView.getBounds());
        }
        this.m_addedToDesktop = false;
        this.m_env.getRootComposite().getDesktopComposite().removeView(this.m_swingView);
    }

    @Override
    public void setTitle(String s) {
        if (s == null) {
            s = "";
        }
        this.m_swingView.setTitle(s);
    }

    @Override
    public void setCloseEnabled(boolean b) {
        this.m_swingView.setClosable(b);
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
        this.m_swingView.setMaximizable(b);
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
        this.m_swingView.setIconifiable(b);
    }

    @Override
    public void setMinimized(boolean on) {
        try {
            this.m_swingView.setIcon(on);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setMaximized(boolean on) {
        this.m_maximized = on;
        try {
            this.m_swingView.setMaximum(on);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setName(String name) {
        this.m_swingView.setName(name);
    }

    private class P_SwingWindowListener
    implements InternalFrameListener {
        private P_SwingWindowListener() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            SwingScoutInternalFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutInternalFrame.this, 10));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component focusOwner;
                    if (!(!SwingScoutInternalFrame.this.m_swingView.isVisible() || SwingScoutInternalFrame.this.m_swingView.isIcon() || (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(focusOwner, SwingScoutInternalFrame.this.m_swingView.getDesktopPane().getRootPane()))) {
                        try {
                            if (!SwingScoutInternalFrame.this.m_swingView.isSelected()) {
                                SwingScoutInternalFrame.this.m_swingView.setSelected(true);
                            }
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            SwingScoutInternalFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutInternalFrame.this, 20));
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            boolean ok;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
                return;
            }
            SwingScoutInternalFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutInternalFrame.this, 30));
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (SwingUtility.VERIFY_INPUT_ON_WINDOW_CLOSED && focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null) {
                ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner);
            }
            SwingScoutInternalFrame.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutInternalFrame.this, 40));
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
        }
    }
}

