/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class SwtColors {
    private final Color white;
    private final Color lightgray;
    private final Color gray;
    private final Color blue;
    private final Color darkgray;
    private final Color red;
    private final Color black;
    private final Color widget_background;
    private HashMap<String, Color> m_registry = new HashMap();
    private HashMap<Integer, Color> m_scoutColorRegistry = new HashMap();
    private static SwtColors instance = null;
    private Display display = Display.getDefault();

    private SwtColors() {
        this.white = this.display.getSystemColor(1);
        this.lightgray = new Color((Device)this.display, 240, 240, 240);
        this.blue = this.display.getSystemColor(26);
        this.gray = this.display.getSystemColor(15);
        this.darkgray = this.display.getSystemColor(16);
        this.red = this.display.getSystemColor(3);
        this.black = this.display.getSystemColor(2);
        this.widget_background = this.display.getSystemColor(22);
    }

    public static SwtColors getInstance() {
        if (instance == null) {
            instance = new SwtColors();
        }
        return instance;
    }

    public Color getWhite() {
        return this.white;
    }

    public Color getLightgray() {
        return this.lightgray;
    }

    public Color getGray() {
        return this.gray;
    }

    public Color getBlue() {
        return this.blue;
    }

    public Color getDarkgray() {
        return this.darkgray;
    }

    public Color getRed() {
        return this.red;
    }

    public Color getBlack() {
        return this.black;
    }

    public Color getColor(RGB rgb) {
        Color c = this.m_registry.get(rgb.toString());
        if (c == null) {
            c = new Color((Device)this.display, rgb);
            this.m_registry.put(rgb.toString(), c);
        }
        return c;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Color getColor(String c) {
        int i = Integer.parseInt(c, 16);
        Color col = this.m_scoutColorRegistry.get(i);
        if (col == null) {
            col = new Color((Device)SwtColors.getStandardDisplay(), i >> 16 & 0xFF, i >> 8 & 0xFF, i >> 0 & 0xFF);
            this.m_scoutColorRegistry.put(i, col);
        }
        return col;
    }

    public Color getDarker(Color c) {
        return this.getDarker(c, 0.75f);
    }

    public Color getDarker(Color c, float ratio) {
        int r = (int)((float)c.getRed() * ratio);
        int g = (int)((float)c.getGreen() * ratio);
        int b = (int)((float)c.getBlue() * ratio);
        return this.getColor(new RGB(r, g, b));
    }

    public void dispose() {
        for (Map.Entry<String, Color> entry : this.m_registry.entrySet()) {
            entry.getValue().dispose();
        }
        for (Map.Entry<Object, Color> entry : this.m_scoutColorRegistry.entrySet()) {
            entry.getValue().dispose();
        }
        this.m_registry.clear();
        this.m_scoutColorRegistry.clear();
    }
}

