/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SwtScoutCellLabelProvider
extends CellLabelProvider {
    private final ISwtEnvironment m_environment;
    private final Color m_disabledForeground;
    private final Color m_disabledBackground;
    private final boolean m_useNativeToolTips;
    private Table m_swtTable;
    private TableColumn m_swtColumn;
    private IColumn<?> m_scoutColumn;

    public SwtScoutCellLabelProvider(IColumn<?> scoutColumn, ISwtEnvironment environment) {
        this.m_scoutColumn = scoutColumn;
        this.m_environment = environment;
        this.m_disabledForeground = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.m_disabledBackground = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorBackgroundDisabled());
        this.m_useNativeToolTips = UiDecorationExtensionPoint.getLookAndFeel().useNativeToolTips();
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        this.m_swtTable = ((TableViewer)viewer).getTable();
        this.m_swtColumn = ((TableViewerColumn)column).getColumn();
        super.initialize(viewer, column);
    }

    public void update(ViewerCell cell) {
        int firstColumnIndex;
        int currentColumnIndex = cell.getColumnIndex();
        boolean firstColumn = currentColumnIndex == (firstColumnIndex = this.m_swtTable.getColumnOrder()[1]);
        ITableRow scoutRow = (ITableRow)cell.getElement();
        ICell scoutCell = scoutRow.getCell(this.m_scoutColumn);
        cell.setText(this.getColumnText(scoutCell));
        cell.setImage(this.getColumnImage(scoutCell, scoutRow, this.m_scoutColumn, firstColumn));
        cell.setBackground(this.getBackground(scoutCell));
        cell.setForeground(this.getForeground(scoutCell, scoutRow));
        cell.setFont(this.getFont(scoutCell));
    }

    public String getToolTipText(Object element) {
        ITableRow scoutRow = (ITableRow)element;
        ICell scoutCell = scoutRow.getCell(this.m_scoutColumn);
        String tooltipText = scoutCell.getTooltipText();
        if (StringUtility.isNullOrEmpty((CharSequence)tooltipText)) {
            return null;
        }
        return tooltipText;
    }

    public boolean useNativeToolTip(Object object) {
        return this.m_useNativeToolTips;
    }

    protected Color getBackground(ICell scoutCell) {
        Color color = this.m_environment.getColor(scoutCell.getBackgroundColor());
        if (color == null && !scoutCell.isEnabled()) {
            return this.m_disabledBackground;
        }
        return color;
    }

    protected Color getForeground(ICell scoutCell, ITableRow scoutRow) {
        Color color = this.m_environment.getColor(scoutCell.getForegroundColor());
        if (!(color != null || scoutRow.isEnabled() && scoutCell.isEnabled())) {
            return this.m_disabledForeground;
        }
        return color;
    }

    protected Image getColumnImage(ICell scoutCell, ITableRow scoutRow, IColumn<?> scoutColumn, boolean firstColumn) {
        String iconId = null;
        if (firstColumn && this.m_scoutColumn.getTable().isCheckable()) {
            iconId = scoutRow.isChecked() ? "checkbox_yes" : "checkbox_no";
        } else if (!(scoutColumn.getDataType() != Boolean.class || scoutColumn instanceof IProposalColumn && ((IProposalColumn)scoutColumn).getLookupCall() != null)) {
            iconId = BooleanUtility.nvl((Boolean)((Boolean)scoutCell.getValue())) ? "checkbox_yes" : "checkbox_no";
        } else if (scoutCell.getErrorStatus() != null && scoutCell.getErrorStatus().getSeverity() == 4) {
            iconId = "status_error";
        } else if (scoutCell.getIconId() != null) {
            iconId = scoutCell.getIconId();
        } else if (firstColumn) {
            iconId = scoutRow.getIconId();
        }
        return iconId != null ? this.m_environment.getIcon(iconId) : null;
    }

    protected String getColumnText(ICell scoutCell) {
        String text = StringUtility.emptyIfNull((Object)scoutCell.getText());
        if (this.m_scoutColumn.getTable().isMultilineText()) {
            return text;
        }
        return StringUtility.removeNewLines((String)text);
    }

    protected Font getFont(ICell scoutCell) {
        return this.m_environment.getFont(scoutCell.getFont(), this.m_swtTable.getFont());
    }
}

