/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.tablefield;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.tablefield.ISwtTableStatus;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SwtTableStatus
implements ISwtTableStatus {
    private final ISwtEnvironment m_env;
    private final Composite m_container;
    private final Label m_populateLabel;
    private final Label m_selectionLabel;
    private boolean m_layoutNeeded;

    public SwtTableStatus(ISwtEnvironment env, Composite container, ITableField<?> model) {
        this.m_env = env;
        this.m_container = container;
        LogicalGridData tableGridData = LogicalGridDataBuilder.createField(model.getGridData());
        this.m_populateLabel = this.m_env.getFormToolkit().createLabel(this.m_container, "", 0);
        this.m_populateLabel.setVisible(false);
        LogicalGridData gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh;
        gd.gridw = tableGridData.gridw;
        gd.gridh = 1;
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        this.m_populateLabel.setLayoutData((Object)gd);
        this.m_selectionLabel = this.m_env.getFormToolkit().createLabel(this.m_container, "", 0);
        this.m_selectionLabel.setVisible(false);
        gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh + 1;
        gd.gridw = tableGridData.gridw;
        gd.gridh = 1;
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        this.m_selectionLabel.setLayoutData((Object)gd);
    }

    @Override
    public void dispose() {
        if (!this.m_populateLabel.isDisposed()) {
            this.m_populateLabel.dispose();
        }
        if (!this.m_selectionLabel.isDisposed()) {
            this.m_selectionLabel.dispose();
        }
    }

    @Override
    public void setStatus(IProcessingStatus populateStatus, IProcessingStatus selectionStatus) {
        this.setStatusImpl(this.m_populateLabel, populateStatus, true);
        this.setStatusImpl(this.m_selectionLabel, selectionStatus, true);
        if (this.m_layoutNeeded) {
            this.m_layoutNeeded = false;
            this.m_container.layout(true, true);
        }
    }

    private void setStatusImpl(Label field, IProcessingStatus status, boolean hideWhenNullStatus) {
        String text;
        if (status == null) {
            field.setText("");
            if (hideWhenNullStatus && field.getVisible()) {
                this.m_layoutNeeded = true;
                field.setVisible(false);
            }
            return;
        }
        if (!field.getVisible()) {
            this.m_layoutNeeded = true;
            field.setVisible(true);
        }
        if ((text = status.getMessage()) != null) {
            text = text.replaceAll("[\\s]+", " ");
        }
        field.setText(text != null ? " " + text : "");
        switch (status.getSeverity()) {
            case 4: 
            case 16: {
                field.setForeground(this.m_env.getColor(new RGB(204, 0, 0)));
                break;
            }
            case 2: 
            case 8: {
                field.setForeground(this.m_env.getColor(new RGB(254, 154, 35)));
                break;
            }
            default: {
                field.setForeground(null);
            }
        }
    }
}

