/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.testing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.testing.internal.SdkTestingApi;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.FieldFilters;
import org.eclipse.scout.sdk.util.type.IFieldFilter;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.junit.Assert;

public class SdkAssert
extends Assert {
    public static void assertExist(IJavaElement element) {
        SdkAssert.assertExist(null, element);
    }

    public static void assertExist(String message, IJavaElement element) {
        if (!TypeUtility.exists((IJavaElement)element)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Element does not exist");
                if (element != null) {
                    messageBuilder.append(" '").append(element.getElementName()).append("'");
                }
                messageBuilder.append("!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertNotExist(IJavaElement element) {
        SdkAssert.assertNotExist(null, element);
    }

    public static void assertNotExist(String message, IJavaElement element) {
        if (TypeUtility.exists((IJavaElement)element)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Element does exist");
                if (element != null) {
                    messageBuilder.append(" '").append(element.getElementName()).append("'");
                }
                messageBuilder.append("!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static IType assertTypeExists(String fullyQualifiedTypeName) {
        return SdkAssert.assertTypeExists(null, fullyQualifiedTypeName);
    }

    public static IType assertTypeExists(String message, String fullyQualifiedTypeName) {
        IType type = TypeUtility.getType((String)fullyQualifiedTypeName);
        if (!TypeUtility.exists((IJavaElement)type)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(fullyQualifiedTypeName).append("'");
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return type;
    }

    public static IType assertTypeExistsBySignature(String signature) {
        return SdkAssert.assertTypeExistsBySignature(null, signature);
    }

    public static IType assertTypeExistsBySignature(String message, String signature) {
        IType type = TypeUtility.getTypeBySignature((String)signature);
        if (!TypeUtility.exists((IJavaElement)type)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(signature).append("'");
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return type;
    }

    public static IType assertTypeExists(ICompilationUnit icu, String typeName) {
        return SdkAssert.assertTypeExists(null, icu, typeName);
    }

    public static IType assertTypeExists(String message, ICompilationUnit icu, String typeName) {
        SdkAssert.assertNotNull((Object)icu);
        IType type = icu.getType(typeName);
        if (!TypeUtility.exists((IJavaElement)type)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(typeName).append("'");
                messageBuilder.append(" in compilation unit '").append(icu.getElementName()).append("'");
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return type;
    }

    public static IType assertTypeExists(IType declaringType, String typeName) {
        return SdkAssert.assertTypeExists(null, declaringType, typeName);
    }

    public static IType assertTypeExists(String message, IType declaringType, String typeName) {
        SdkAssert.assertNotNull((Object)declaringType);
        IType type = declaringType.getType(typeName);
        if (!TypeUtility.exists((IJavaElement)type)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(typeName).append("'");
                messageBuilder.append(" in type '").append(declaringType.getElementName()).append("'");
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return type;
    }

    public static IMethod assertMethodExist(IType type, String methodName) {
        return SdkAssert.assertMethodExist(null, type, methodName);
    }

    public static IMethod assertMethodExist(String message, IType type, String methodName) {
        IMethod method = TypeUtility.getMethod((IType)type, (String)methodName);
        if (!TypeUtility.exists((IJavaElement)method)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Method '").append(methodName).append("'");
                if (type != null) {
                    messageBuilder.append(" in type '").append(type.getElementName()).append("'");
                }
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return method;
    }

    public static IMethod assertMethodExist(IType type, String methodName, String[] parameterSignatures) {
        return SdkAssert.assertMethodExist(null, type, methodName, parameterSignatures);
    }

    public static IMethod assertMethodExist(String message, IType type, final String methodName, final String[] parameterSignatures) {
        IMethod method = TypeUtility.getFirstMethod((IType)type, (IMethodFilter)new IMethodFilter(){

            public boolean accept(IMethod candidate) throws CoreException {
                String[] refParameterSignatures;
                if (CompareUtility.equals((Object)methodName, (Object)candidate.getElementName()) && parameterSignatures.length == (refParameterSignatures = candidate.getParameterTypes()).length) {
                    boolean matches = true;
                    int i = 0;
                    while (i < parameterSignatures.length) {
                        if (!CompareUtility.equals((Object)SignatureUtility.getResolvedSignature((String)parameterSignatures[i], (IType)candidate.getDeclaringType()), (Object)SignatureUtility.getResolvedSignature((String)refParameterSignatures[i], (IType)candidate.getDeclaringType()))) {
                            matches = false;
                            break;
                        }
                        ++i;
                    }
                    return matches;
                }
                return false;
            }
        });
        if (!TypeUtility.exists((IJavaElement)method)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Method '").append(methodName).append("'");
                if (type != null) {
                    messageBuilder.append(" in type '").append(type.getElementName()).append("'");
                }
                messageBuilder.append(" does not exist! [parameters: ");
                int i = 0;
                while (i < parameterSignatures.length) {
                    messageBuilder.append("'").append(parameterSignatures[i]).append("'");
                    if (i < parameterSignatures.length - 1) {
                        messageBuilder.append(", ");
                    }
                    ++i;
                }
                messageBuilder.append("]");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return method;
    }

    public static IMethod assertMethodExistInSuperTypeHierarchy(IType type, String methodName) {
        return SdkAssert.assertMethodExistInSuperTypeHierarchy(null, type, methodName);
    }

    public static IMethod assertMethodExistInSuperTypeHierarchy(String message, IType type, String methodName) {
        IMethod method = TypeUtility.findMethodInSupertypeHierarchy((String)methodName, (IType)type, (ITypeHierarchy)TypeUtility.getSupertypeHierarchy((IType)type));
        if (!TypeUtility.exists((IJavaElement)method)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Method '").append(methodName).append("'");
                if (type != null) {
                    messageBuilder.append(" in type '").append(type.getElementName()).append("'");
                }
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return method;
    }

    public static void assertMethodReturnTypeSignature(IMethod method, String expectedSignature) throws CoreException {
        SdkAssert.assertMethodReturnTypeSignature(null, method, expectedSignature);
    }

    public static void assertMethodReturnTypeSignature(String message, IMethod method, String expectedSignature) throws CoreException {
        String signature = SignatureUtility.getResolvedSignature((String)method.getReturnType(), (IType)method.getDeclaringType());
        if (!CompareUtility.equals((Object)signature, (Object)(expectedSignature = SignatureUtility.getResolvedSignature((String)expectedSignature, (IType)method.getDeclaringType())))) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Method return type not equal! [expected: '").append(expectedSignature).append("', actual: '").append(signature).append("'] '");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertMethodParameterSignatures(IMethod method, String[] expectedSignatures) throws CoreException {
        SdkAssert.assertMethodParameterSignatures(null, method, expectedSignatures);
    }

    public static void assertMethodParameterSignatures(String message, IMethod method, String[] expectedSignatures) throws CoreException {
        Object[] parameterSignatures = method.getParameterTypes();
        if (parameterSignatures.length == expectedSignatures.length) {
            int i = 0;
            while (i < parameterSignatures.length) {
                parameterSignatures[i] = SignatureUtility.getResolvedSignature((String)parameterSignatures[i], (IType)method.getDeclaringType());
                expectedSignatures[i] = SignatureUtility.getResolvedSignature((String)expectedSignatures[i], (IType)method.getDeclaringType());
                ++i;
            }
            Arrays.sort(parameterSignatures);
            Arrays.sort(expectedSignatures);
            i = 0;
            while (i < parameterSignatures.length) {
                if (!CompareUtility.equals((Object)parameterSignatures[i], (Object)expectedSignatures[i])) {
                    if (message == null) {
                        StringBuilder messageBuilder = new StringBuilder("Method '").append(method.getElementName()).append("' does not have the same parameter signature! [expected '").append(expectedSignatures[i]).append("', actual '").append((String)parameterSignatures[i]).append("']");
                        message = messageBuilder.toString();
                    }
                    SdkAssert.fail((String)message);
                    break;
                }
                ++i;
            }
        } else {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Method '").append(method.getElementName()).append("' does not have the same same amount of parameters! [expected: ").append(expectedSignatures.length).append(", actual: ").append(parameterSignatures.length).append("]");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertMethodValidationRules(IMethod initValidationRulesMethod, String[] validationRuleLines, boolean superCall) throws JavaModelException {
        ISourceRange range = TypeUtility.getContentSourceRange((IMethod)initValidationRulesMethod);
        String source = initValidationRulesMethod.getOpenable().getBuffer().getText(range.getOffset(), range.getLength());
        SdkAssert.assertNotNull((Object)source);
        HashSet<String> expectedLines = new HashSet<String>(Arrays.asList(validationRuleLines));
        BufferedReader reader = null;
        try {
            StringBuilder messageBuilder;
            reader = new BufferedReader(new StringReader(source));
            String line = reader.readLine();
            while (line != null) {
                if (StringUtility.hasText((CharSequence)(line = line.trim())) && !line.matches("^super\\.initValidationRules\\([^\\)]*\\)\\;$") && !expectedLines.remove(line)) {
                    messageBuilder = new StringBuilder();
                    messageBuilder.append("Validation rules failer. Validation rule '").append(line).append("' was not expected!");
                    SdkAssert.fail((String)messageBuilder.toString());
                }
                line = reader.readLine();
            }
            if (!expectedLines.isEmpty()) {
                messageBuilder = new StringBuilder();
                messageBuilder.append("Validation rules failer. The following expected validation rules are not found in code: [");
                Iterator expectedIt = expectedLines.iterator();
                messageBuilder.append((String)expectedIt.next());
                while (expectedIt.hasNext()) {
                    messageBuilder.append(", ").append((String)expectedIt.next());
                }
                messageBuilder.append("]");
                SdkAssert.fail((String)messageBuilder.toString());
            }
        }
        catch (IOException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    SdkTestingApi.logError("could not close reader.", e1);
                }
            }
            SdkTestingApi.logError("could not parse initValidationRulesMethod on '" + initValidationRulesMethod.getDeclaringType().getFullyQualifiedName() + "'.", e);
        }
    }

    public static IField assertFieldExist(IType type, String fieldName) {
        return SdkAssert.assertFieldExist(null, type, fieldName);
    }

    public static IField assertFieldExist(String message, IType type, String fieldName) {
        IField field = TypeUtility.getFirstField((IType)type, (IFieldFilter)FieldFilters.getNameFilter((String)fieldName));
        if (!TypeUtility.exists((IJavaElement)field)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Field '").append(fieldName).append("'");
                if (type != null) {
                    messageBuilder.append(" in type '").append(type.getElementName()).append("'");
                }
                messageBuilder.append(" does not exist!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        return field;
    }

    public static void assertFieldSignature(IField field, String expectedSignature) throws CoreException {
        SdkAssert.assertFieldSignature(null, field, expectedSignature);
    }

    public static void assertFieldSignature(String message, IField field, String expectedSignature) throws CoreException {
        String expectedResolvedSignature;
        String resolvedSignature = SignatureUtility.getResolvedSignature((String)field.getTypeSignature(), (IType)field.getDeclaringType());
        if (!CompareUtility.equals((Object)resolvedSignature, (Object)(expectedResolvedSignature = SignatureUtility.getResolvedSignature((String)expectedSignature, (IType)field.getDeclaringType())))) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Field '").append(field.getElementName()).append("' does not have the expected type signature! [expected:'").append(expectedResolvedSignature).append("', actual:'").append(resolvedSignature).append("']");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertHasSuperType(IType type, String superTypeFqn) {
        SdkAssert.assertHasSuperType(null, type, superTypeFqn);
    }

    public static void assertHasSuperType(String message, IType type, String superTypeFqn) {
        if (!TypeUtility.getSupertypeHierarchy((IType)type).contains(TypeUtility.getType((String)superTypeFqn))) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(type.getFullyQualifiedName()).append("' does not have '").append(superTypeFqn).append("' as supertype!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertHasSuperTypeSignature(IType type, String superTypeSignature) throws CoreException {
        SdkAssert.assertHasSuperTypeSignature(null, type, superTypeSignature);
    }

    public static void assertHasSuperTypeSignature(String message, IType type, String superTypeSignature) throws CoreException {
        String refSuperTypeSig = SignatureUtility.getResolvedSignature((String)type.getSuperclassTypeSignature(), (IType)type);
        if (!CompareUtility.equals((Object)refSuperTypeSig, (Object)(superTypeSignature = SignatureUtility.getResolvedSignature((String)superTypeSignature, (IType)type)))) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(type.getFullyQualifiedName()).append("' does not have expected supertype! [expected '").append(superTypeSignature).append("', actual '").append(refSuperTypeSig).append("']");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertHasSuperIntefaceSignatures(IType type, String[] interfaceSignatures) throws CoreException {
        SdkAssert.assertHasSuperIntefaceSignatures(null, type, interfaceSignatures);
    }

    public static void assertHasSuperIntefaceSignatures(String message, IType type, String[] interfaceSignatures) throws CoreException {
        Object[] refInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
        if (refInterfaceSignatures.length == interfaceSignatures.length) {
            int i = 0;
            while (i < interfaceSignatures.length) {
                interfaceSignatures[i] = SignatureUtility.getResolvedSignature((String)interfaceSignatures[i], (IType)type);
                refInterfaceSignatures[i] = SignatureUtility.getResolvedSignature((String)refInterfaceSignatures[i], (IType)type);
                ++i;
            }
            Arrays.sort(interfaceSignatures);
            Arrays.sort(refInterfaceSignatures);
            i = 0;
            while (i < interfaceSignatures.length) {
                if (!CompareUtility.equals((Object)interfaceSignatures[i], (Object)refInterfaceSignatures[i])) {
                    if (message == null) {
                        StringBuilder messageBuilder = new StringBuilder("Type '").append(type.getFullyQualifiedName()).append("' does not have the same interfaces! [").append((String)refInterfaceSignatures[i]).append(", ").append(interfaceSignatures[i]).append("]");
                        message = messageBuilder.toString();
                    }
                    SdkAssert.fail((String)message);
                    break;
                }
                ++i;
            }
        } else {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Type '").append(type.getElementName()).append("' does not have the same same amount of interfaces! [expected: ").append(interfaceSignatures.length).append(", actual: ").append(refInterfaceSignatures.length).append("]");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static IField assertSerialVersionUidExists(IType type) throws JavaModelException {
        return SdkAssert.assertSerialVersionUidExists(null, type);
    }

    public static IField assertSerialVersionUidExists(String message, IType type) throws JavaModelException {
        IField field = SdkAssert.assertFieldExist(message, type, "serialVersionUID");
        SdkAssert.assertPrivate(message, (IMember)field).assertStatic().assertFinal();
        return field;
    }

    public static IAnnotation assertAnnotation(IAnnotatable annotatable, String fqAnnotationTypeName) {
        IAnnotation annotation = JdtUtility.getAnnotation((IAnnotatable)annotatable, (String)fqAnnotationTypeName);
        if (annotation == null || !annotation.exists()) {
            StringBuilder message = new StringBuilder("Element '");
            if (annotatable instanceof IJavaElement) {
                message.append(((IJavaElement)annotatable).getElementName());
            } else {
                message.append(annotatable.toString());
            }
            message.append("' does not have the expected annotation '").append(fqAnnotationTypeName).append("'.");
            SdkAssert.fail((String)message.toString());
        }
        return annotation;
    }

    public static void assertOrderAnnotation(IAnnotatable annotatable, Double orderNr) throws JavaModelException {
        SdkAssert.assertOrderAnnotation(null, annotatable, orderNr);
    }

    public static void assertOrderAnnotation(String message, IAnnotatable annotatable, Double orderNr) throws JavaModelException {
        Double memberOrderNr = ScoutTypeUtility.getOrderAnnotationValue((IAnnotatable)annotatable);
        if (!CompareUtility.equals((Object)orderNr, (Object)memberOrderNr)) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("Order annotation not equal: exptected '").append(orderNr).append("'; found on member");
                if (annotatable != null && annotatable instanceof IMember) {
                    messageBuilder.append(" '").append(((IMember)annotatable).getElementName()).append("'");
                }
                messageBuilder.append(" is '").append(memberOrderNr).append("'!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
        SdkAssert.assertEquals((String)message, (Object)memberOrderNr, (Object)orderNr);
    }

    public static void assertSameParent(IJavaElement ... elements) {
        SdkAssert.assertSameParent(null, elements);
    }

    public static void assertSameParent(String message, IJavaElement ... elements) {
        if (elements != null) {
            IJavaElement parent = null;
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (parent == null) {
                    parent = element.getParent();
                } else {
                    SdkAssert.assertEquals((String)message, (Object)parent, (Object)element.getParent());
                }
                ++n2;
            }
        }
    }

    public static void assertElementSequenceInSource(IMember ... elements) throws JavaModelException {
        SdkAssert.assertElementSequenceInSource(null, elements);
    }

    public static void assertElementSequenceInSource(String message, IMember ... elements) throws JavaModelException {
        SdkAssert.assertSameParent((IJavaElement[])elements);
        if (elements != null) {
            int index = -1;
            IMember[] iMemberArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IMember element = iMemberArray[n2];
                ISourceRange sourceRange = element.getSourceRange();
                if (index >= sourceRange.getOffset()) {
                    SdkAssert.fail((String)message);
                } else {
                    index = sourceRange.getOffset() + sourceRange.getLength();
                }
                ++n2;
            }
        }
    }

    public static void assertHasFlags(IMember member, int flags) throws JavaModelException {
        SdkAssert.assertHasFlags(null, member, flags);
    }

    public static void assertHasFlags(String message, IMember member, int flags) throws JavaModelException {
        int memberFlags = member.getFlags();
        if ((flags & memberFlags) != flags) {
            if (message == null) {
                StringBuilder messageBuilder = new StringBuilder("member '").append(member.getElementName()).append("'");
                messageBuilder.append(" has flags [").append(Flags.toString((int)memberFlags)).append("] expected [").append(Flags.toString((int)flags)).append("]!");
                message = messageBuilder.toString();
            }
            SdkAssert.fail((String)message);
        }
    }

    public static void assertServiceProxyRegistered(IProject project, IType serviceInterface) {
        List simpleExtensions = new PluginModelHelper((IProject)project).PluginXml.getSimpleExtensions("org.eclipse.scout.service.services", "proxy");
        for (IPluginElement element : simpleExtensions) {
            if (!CompareUtility.equals((Object)element.getAttribute("class").getValue(), (Object)serviceInterface.getFullyQualifiedName())) continue;
            return;
        }
        SdkAssert.fail((String)("proxy for service '" + serviceInterface.getElementName() + "' ist not registered in project '" + project.getName() + "'"));
    }

    public static void assertServiceRegistered(IProject project, IType serviceInterface) {
        List simpleExtensions = new PluginModelHelper((IProject)project).PluginXml.getSimpleExtensions("org.eclipse.scout.service.services", "service");
        for (IPluginElement element : simpleExtensions) {
            if (!CompareUtility.equals((Object)element.getAttribute("class").getValue(), (Object)serviceInterface.getFullyQualifiedName())) continue;
            return;
        }
        SdkAssert.fail((String)("service '" + serviceInterface.getElementName() + "' ist not registered in project '" + project.getName() + "'"));
    }

    public static FlagAssert assertPrivate(IMember member) throws JavaModelException {
        return SdkAssert.assertPrivate(null, member);
    }

    public static FlagAssert assertPrivate(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertPrivate();
    }

    public static FlagAssert assertProtected(IMember member) throws JavaModelException {
        return SdkAssert.assertProtected(null, member);
    }

    public static FlagAssert assertProtected(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertProtected();
    }

    public static FlagAssert assertPublic(IMember member) throws JavaModelException {
        return SdkAssert.assertPublic(null, member);
    }

    public static FlagAssert assertPublic(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertPublic();
    }

    public static FlagAssert assertAbstract(IMember member) throws JavaModelException {
        return SdkAssert.assertAbstract(null, member);
    }

    public static FlagAssert assertAbstract(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertAbstract();
    }

    public static FlagAssert assertFinal(IMember member) throws JavaModelException {
        return SdkAssert.assertFinal(null, member);
    }

    public static FlagAssert assertFinal(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertFinal();
    }

    public static FlagAssert assertInterface(IMember member) throws JavaModelException {
        return SdkAssert.assertInterface(null, member);
    }

    public static FlagAssert assertInterface(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertInterface();
    }

    public static FlagAssert assertStatic(IMember member) throws JavaModelException {
        return SdkAssert.assertStatic(null, member);
    }

    public static FlagAssert assertStatic(String message, IMember member) throws JavaModelException {
        return new FlagAssert(message, member).assertStatic();
    }

    public static TypeAssert typeAssert(IType declaringType, String typeName) throws JavaModelException {
        IType type = SdkAssert.assertTypeExists(declaringType, typeName);
        return new TypeAssert(type);
    }

    public static MethodAssert methodAssert(IType type, String methodname) throws JavaModelException {
        IMethod method = SdkAssert.assertMethodExist(type, methodname);
        return new MethodAssert(method);
    }

    public static class FlagAssert {
        private int m_flags;
        private final IMember m_member;
        private final String m_message;

        public FlagAssert(String message, IMember member) throws JavaModelException {
            this.m_message = message;
            this.m_member = member;
            this.m_flags = member.getFlags();
        }

        public FlagAssert assertPrivate() {
            if (!Flags.isPrivate((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)2));
            }
            this.m_flags ^= 2;
            return this;
        }

        public FlagAssert assertProtected() {
            if (!Flags.isProtected((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)4));
            }
            this.m_flags ^= 4;
            return this;
        }

        public FlagAssert assertPublic() {
            if (!Flags.isPublic((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)1));
            }
            this.m_flags ^= 1;
            return this;
        }

        public FlagAssert assertAbstract() {
            if (!Flags.isAbstract((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)1024));
            }
            this.m_flags ^= 0x400;
            return this;
        }

        public FlagAssert assertFinal() {
            if (!Flags.isFinal((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)16));
            }
            this.m_flags ^= 0x10;
            return this;
        }

        public FlagAssert assertInterface() {
            if (!Flags.isInterface((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)512));
            }
            this.m_flags ^= 0x200;
            return this;
        }

        public FlagAssert assertStatic() {
            if (!Flags.isStatic((int)this.m_flags)) {
                this.flagFailed(Flags.toString((int)8));
            }
            this.m_flags ^= 8;
            return this;
        }

        public FlagAssert assertNoMoreFlags() {
            if (this.m_flags != 0) {
                if (this.m_message == null) {
                    StringBuilder message = new StringBuilder("member");
                    if (this.m_member != null) {
                        message.append(" '").append(this.m_member.getElementName()).append("'");
                    }
                    message.append(" has still flags [").append(Flags.toString((int)this.m_flags)).append("]!");
                    SdkAssert.fail((String)message.toString());
                } else {
                    SdkAssert.fail((String)this.m_message);
                }
            }
            return this;
        }

        public void flagFailed(String flagName) {
            if (this.m_message == null) {
                StringBuilder message = new StringBuilder("member");
                if (this.m_member != null) {
                    message.append(" '").append(this.m_member.getElementName()).append("'");
                }
                message.append(" is not ").append(flagName).append("!");
                SdkAssert.fail((String)message.toString());
            } else {
                SdkAssert.fail((String)this.m_message);
            }
        }
    }

    public static class MethodAssert {
        private IMethod m_method;

        public MethodAssert(IMethod method) throws JavaModelException {
            this.m_method = method;
        }

        public MethodAssert assertExits() {
            SdkAssert.assertExist((IJavaElement)this.m_method);
            return this;
        }

        public MethodAssert assertParameterCount(int expected) throws JavaModelException {
            ILocalVariable[] parameters = this.m_method.getParameters();
            if (parameters.length != expected) {
                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.append("Parameter count of method '").append(this.m_method.getElementName()).append("': expected:'").append(expected).append("' actual:'").append(parameters.length).append("'.");
                SdkAssert.fail((String)messageBuilder.toString());
            }
            return this;
        }

        public MethodAssert assertConstructor() throws JavaModelException {
            if (!this.m_method.isConstructor()) {
                SdkAssert.fail((String)("method '" + this.m_method.getElementName() + "' is expected to be a constructor."));
            }
            return this;
        }

        public MethodAssert assertReturnType(String returnTypeFqn) throws JavaModelException {
            String retSig = this.m_method.getReturnType();
            String qualifier = Signature.getSignatureQualifier((String)retSig);
            String simpleName = Signature.getSignatureSimpleName((String)retSig);
            if (!StringUtility.isNullOrEmpty((CharSequence)qualifier)) {
                SdkAssert.assertEquals((Object)qualifier, (Object)Signature.getQualifier((String)returnTypeFqn));
            }
            SdkAssert.assertEquals((Object)simpleName, (Object)Signature.getSimpleName((String)returnTypeFqn));
            return this;
        }

        public FlagAssert flagAssert() throws JavaModelException {
            return new FlagAssert(null, (IMember)this.m_method);
        }

        public IMethod getMethod() {
            return this.m_method;
        }
    }

    public static class TypeAssert {
        private IType m_type;

        public TypeAssert(IType type) {
            this.m_type = type;
        }

        public TypeAssert assertExist() throws JavaModelException {
            SdkAssert.assertExist((IJavaElement)this.m_type);
            return this;
        }

        public TypeAssert assertSuperClass(String fqn) throws JavaModelException {
            SdkAssert.assertHasSuperType(this.m_type, fqn);
            return this;
        }

        public FlagAssert flagAssert() throws JavaModelException {
            return new FlagAssert(null, (IMember)this.m_type);
        }

        public IType getType() {
            return this.m_type;
        }
    }
}

