/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.testing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.jdt.compile.ICompileResult;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.testing.internal.SdkTestingApi;
import org.eclipse.scout.sdk.util.internal.typecache.HierarchyCache;
import org.eclipse.scout.sdk.util.internal.typecache.ICacheableTypeHierarchyResult;
import org.eclipse.scout.sdk.util.internal.typecache.TypeCache;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public final class TestWorkspaceUtility {
    private TestWorkspaceUtility() {
    }

    public static void setupWorkspace(Bundle resourceBundle, String baseFolder, String ... projects) throws CoreException, IOException {
        Assert.assertNotNull((String)"baseFolder must not be null", (Object)baseFolder);
        if (projects == null || projects.length == 0) {
            projects = new String[1];
        }
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String project = stringArray[n2];
            IProject javaProject = TestWorkspaceUtility.createProject(project);
            TestWorkspaceUtility.copyProject(resourceBundle, baseFolder, project);
            javaProject.close(null);
            javaProject.open(null);
            ++n2;
        }
        TestWorkspaceUtility.buildWorkspace();
    }

    public static void clearWorkspace() throws CoreException {
        Job delJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    try {
                        p.refreshLocal(2, monitor);
                        p.delete(true, true, monitor);
                    }
                    catch (Exception e) {
                        SdkTestingApi.logWarning("Unable to delete project '" + p + "'.", e);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        delJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        delJob.schedule();
        try {
            delJob.join();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)monitor);
        JdtUtility.waitForSilentWorkspace();
        ResourcesPlugin.getWorkspace().forgetSavedTree(null);
        ResourcesPlugin.getWorkspace().getRoot().clearHistory((IProgressMonitor)monitor);
    }

    public static void executeAndBuildWorkspace(IOperation ... ops) throws CoreException {
        OperationJob job = new OperationJob(ops);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        if (!job.getResult().isOK()) {
            StringBuilder statusBuilder = new StringBuilder();
            TestWorkspaceUtility.createStatusLog(job.getResult(), statusBuilder, 0);
            Assert.fail((String)statusBuilder.toString());
        }
        Assert.assertTrue((boolean)job.getResult().isOK());
        TestWorkspaceUtility.buildWorkspace();
    }

    private static void createStatusLog(IStatus status, StringBuilder builder, int indent) {
        Throwable exception;
        int i = 0;
        while (i < indent) {
            builder.append("  ");
            ++i;
        }
        if (status.isMultiStatus()) {
            builder.append("Multi Status:").append("\n");
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                TestWorkspaceUtility.createStatusLog(childStatus, builder, indent + 1);
                ++n2;
            }
        }
        switch (status.getSeverity()) {
            case 8: {
                builder.append("CANCEL: ");
                break;
            }
            case 4: {
                builder.append("ERROR: ");
                break;
            }
            case 2: {
                builder.append("WARNING: ");
            }
        }
        String message = status.getMessage();
        if (StringUtility.hasText((CharSequence)message)) {
            builder.append(message);
        }
        if ((exception = status.getException()) != null) {
            StringWriter dest = new StringWriter();
            PrintWriter w = new PrintWriter(dest);
            exception.printStackTrace(w);
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(dest.getBuffer());
        }
    }

    public static void buildWorkspaceAndAssertNoCompileErrors() throws CoreException {
        TestWorkspaceUtility.buildWorkspace();
        TestWorkspaceUtility.assertNoCompileErrors();
    }

    public static void buildWorkspace() throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)monitor);
        TestWorkspaceUtility.waitForNotifyJob();
        JdtUtility.waitForSilentWorkspace();
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)monitor);
        JdtUtility.waitForSilentWorkspace();
        TestWorkspaceUtility.waitForNotifyJob();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)monitor);
        JdtUtility.waitForSilentWorkspace();
        TestWorkspaceUtility.waitForNotifyJob();
    }

    private static void waitForNotifyJob() throws CoreException {
        IWorkspaceRunnable noop = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
            }
        };
        ResourcesPlugin.getWorkspace().run(noop, null, 0, null);
    }

    public static void assertNoCompileErrors() {
        ICompileResult result = ScoutSeverityManager.getInstance().getCompileResult((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (result.getSeverity() >= 2) {
            StringBuilder builder = new StringBuilder("Compile errors:\n");
            List errorMarkers = result.getErrorMarkers();
            int i = 0;
            while (i < errorMarkers.size()) {
                if (i > 0) {
                    builder.append("\n");
                }
                IMarker m = (IMarker)errorMarkers.get(i);
                int severity = m.getAttribute("severity", -1);
                switch (severity) {
                    case 0: {
                        builder.append("INFO: ");
                        break;
                    }
                    case 1: {
                        builder.append("WARNING: ");
                        break;
                    }
                    case 2: {
                        builder.append("ERROR: ");
                        break;
                    }
                    default: {
                        builder.append("UNDEFINED SEVERITY: ");
                    }
                }
                IResource resource = m.getResource();
                if (ResourceUtility.exists((IResource)resource)) {
                    builder.append(resource.getName()).append(" - ").append(resource.getParent().getProjectRelativePath()).append(" - ");
                }
                builder.append("line:").append(m.getAttribute("lineNumber", -1)).append(" - ");
                builder.append(m.getAttribute("message", "")).append(" ");
                ++i;
            }
            Assert.fail((String)builder.toString());
        }
    }

    protected static void copyProject(Bundle resourceBundle, String ... pathElements) throws IOException {
        URL resource = FileLocator.find((Bundle)resourceBundle, (IPath)TestWorkspaceUtility.createPath(pathElements), null);
        if (resource != null) {
            String path = FileLocator.toFileURL((URL)resource).getPath();
            TestWorkspaceUtility.copyFilesRecursive(path, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
    }

    public static IProject createProject(String projectName) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create((IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
        return project;
    }

    protected static Path createPath(String ... pathElements) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e != null) {
                builder.append("/");
                builder.append(e);
            }
            ++n2;
        }
        return new Path(builder.toString());
    }

    private static void copyFilesRecursive(String from, String toDir) throws IOException {
        File[] fileList;
        File fromFile = new File(from);
        if (!fromFile.exists()) {
            return;
        }
        if (fromFile.isDirectory()) {
            if (".svn".equalsIgnoreCase(fromFile.getName())) {
                return;
            }
            File subDir = new File(toDir, fromFile.getName());
            if (!subDir.exists() && !subDir.mkdir()) {
                throw new IOException("Unable to create file directory '" + subDir.getAbsolutePath() + "'.");
            }
            toDir = String.valueOf(toDir) + "/" + fromFile.getName();
        }
        if ((fileList = fromFile.listFiles()) == null || fileList.length == 0) {
            return;
        }
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                TestWorkspaceUtility.copyFilesRecursive(String.valueOf(from) + "/" + file.getName(), toDir);
            } else {
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file));
                    out = new BufferedOutputStream(new FileOutputStream(String.valueOf(toDir) + "/" + file.getName()));
                    while ((bytesRead = in.read(buffer)) > 0) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            ++n2;
        }
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public void printWorkspace(String title, PrintStream out) {
        out.println("---print WS [" + title + "] ----");
        out.println("Bundles:");
        for (IScoutBundle b : ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getAllBundlesFilter())) {
            if (b != null) {
                out.println(" - " + b.getSymbolicName());
                continue;
            }
            out.println(" - Null bundle");
        }
        out.println("Hierarchies:");
        for (ICacheableTypeHierarchyResult h : HierarchyCache.getInstance().getAllCachedHierarchies()) {
            out.println(" - " + h.getBaseType().getFullyQualifiedName());
        }
        out.println("TypeCache: (size='" + TypeCache.getInstance().getAllCachedTypes().size() + "')");
        out.println("--- END [" + title + "] ----");
    }

    public static void copyTemplateToBuffer(IProject project, String ressourcePath, StringBuilder source, String lineDelimiter) throws CoreException {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(((IFile)project.findMember(ressourcePath)).getContents()));
                String line = reader.readLine();
                while (line != null) {
                    source.append(line).append(lineDelimiter);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

