/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MemberSelectionDialog
extends TitleAreaDialog {
    private Set<? extends IMember> m_members;
    private Set<? extends IMember> m_selectedMembers;
    private CheckboxTableViewer m_viewer;
    private EventListenerList m_listeners;
    private final String m_title;
    private final String m_message;

    public MemberSelectionDialog(Shell parentShell, String title) {
        this(parentShell, title, null);
    }

    public MemberSelectionDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.m_title = title;
        this.m_message = message;
        this.m_listeners = new EventListenerList();
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        if (this.m_message != null) {
            this.setMessage(this.m_message);
        }
        if (this.m_title != null) {
            this.setTitle(this.m_title);
        }
        return ret;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_title != null) {
            newShell.setText(this.m_title);
        }
    }

    public void setMembers(Set<? extends IMember> members) {
        this.m_members = new LinkedHashSet<IMember>(members);
    }

    public Set<? extends IMember> getMembers() {
        return new LinkedHashSet<IMember>(this.m_members);
    }

    public void setSelectedMembers(Set<? extends IMember> selectedMembers) {
        this.m_selectedMembers = selectedMembers == null ? new LinkedHashSet<IMember>(0) : new LinkedHashSet<IMember>(selectedMembers);
        if (this.m_viewer != null && !this.m_viewer.getTable().isDisposed()) {
            this.m_viewer.setCheckedElements((Object[])this.m_selectedMembers.toArray(new IMember[this.m_selectedMembers.size()]));
            this.fireSelectionChanged(this.m_selectedMembers);
        }
    }

    public Set<? extends IMember> getSelectedMembers() {
        return new LinkedHashSet<IMember>(this.m_selectedMembers);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        AutoResizeColumnTable table = new AutoResizeColumnTable(rootPane, 67616);
        TableColumn simpleNameCol = new TableColumn((Table)table, 16384);
        simpleNameCol.setData("columnWeight", (Object)3);
        simpleNameCol.setWidth(170);
        simpleNameCol.setText("Member");
        TableColumn packageCol = new TableColumn((Table)table, 16384);
        packageCol.setData("columnWeight", (Object)5);
        packageCol.setText("Package");
        packageCol.setWidth(270);
        this.m_viewer = new CheckboxTableViewer((Table)table);
        this.m_viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checkedElements = MemberSelectionDialog.this.m_viewer.getCheckedElements();
                LinkedHashSet<IMember> newChecked = new LinkedHashSet<IMember>(checkedElements.length);
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object m = objectArray[n2];
                    if (m instanceof IMember) {
                        newChecked.add((IMember)m);
                    }
                    ++n2;
                }
                MemberSelectionDialog.this.m_selectedMembers = newChecked;
                MemberSelectionDialog.this.fireSelectionChanged(MemberSelectionDialog.this.m_selectedMembers);
            }
        });
        P_TableContentProvider provider = new P_TableContentProvider();
        this.m_viewer.setContentProvider((IContentProvider)provider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.m_viewer.setInput((Object)provider);
        this.m_viewer.setCheckedElements(this.getSelectedMembers().toArray());
        Control buttonArea = this.createButtons(rootPane);
        if (parent.getLayout() instanceof GridLayout) {
            rootPane.setLayoutData((Object)new GridData(1808));
        }
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_viewer.getTable().setLayoutData((Object)new GridData(1808));
        buttonArea.setLayoutData((Object)new GridData());
        return rootPane;
    }

    protected Control createButtons(Composite parent) {
        Composite buttonArea = new Composite(parent, 0);
        Button selectAll = new Button(buttonArea, 0x800008);
        selectAll.setText("select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemberSelectionDialog.this.setSelectedMembers(MemberSelectionDialog.this.getMembers());
            }
        });
        Button deselectAll = new Button(buttonArea, 0x800008);
        deselectAll.setText("deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemberSelectionDialog.this.setSelectedMembers(null);
            }
        });
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 5;
        buttonArea.setLayout((Layout)layout);
        selectAll.setLayoutData((Object)new GridData(768));
        deselectAll.setLayoutData((Object)new GridData(768));
        return buttonArea;
    }

    public void addMemberSelectionListener(IMemberSelectionChangedListener listener) {
        this.m_listeners.add(IMemberSelectionChangedListener.class, (EventListener)listener);
    }

    public void removeMemberSelectionListener(IMemberSelectionChangedListener listener) {
        this.m_listeners.remove(IMemberSelectionChangedListener.class, (EventListener)listener);
    }

    protected void fireSelectionChanged(final Set<? extends IMember> selectedMembers) {
        IMemberSelectionChangedListener[] iMemberSelectionChangedListenerArray = (IMemberSelectionChangedListener[])this.m_listeners.getListeners(IMemberSelectionChangedListener.class);
        int n = iMemberSelectionChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IMemberSelectionChangedListener listener = iMemberSelectionChangedListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.handleSelectionChanged(selectedMembers);
                }
            });
            ++n2;
        }
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private P_TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return MemberSelectionDialog.this.getMembers().toArray();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (columnIndex == 0) {
                try {
                    switch (((IMember)element).getElementType()) {
                        case 7: {
                            if (((IType)element).isInterface()) {
                                img = ScoutSdkUi.getImage("innerinterface_obj.gif");
                                break;
                            }
                            img = ScoutSdkUi.getImage("class_obj.gif");
                            break;
                        }
                        case 9: {
                            img = ScoutSdkUi.getImage("public_co.gif");
                            break;
                        }
                        case 8: {
                            img = ScoutSdkUi.getImage("field_private_obj.gif");
                            break;
                        }
                        default: {
                            img = ScoutSdkUi.getImage("default.gif");
                            break;
                        }
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logWarning(e);
                }
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            IMember member = (IMember)element;
            switch (columnIndex) {
                case 0: {
                    return member.getElementName();
                }
                case 1: {
                    if (member.getElementType() == 7) {
                        return ((IType)member).getPackageFragment().getElementName();
                    }
                    if (member.getElementType() != 9) break;
                    return ((IMethod)member).getDeclaringType().getFullyQualifiedName();
                }
            }
            return "";
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

