/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.template.CreateTemplateOperation;
import org.eclipse.scout.sdk.ui.dialog.TemplateFromFormFieldDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class CreateTemplateExecutor
extends AbstractExecutor {
    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        IType type = UiUtility.getTypeFromSelection(selection);
        String name = "Abstract" + type.getElementName();
        TemplateFromFormFieldDialog dialog = new TemplateFromFormFieldDialog(shell, name, type);
        if (dialog.open() == 0) {
            IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)type);
            CreateTemplateOperation op = new CreateTemplateOperation(type, bundle);
            op.setTemplateName(dialog.getTemplateName());
            op.setPackageName(bundle.getPackageName(dialog.getTargetPackage()));
            op.setFormDataPackageSuffix(dialog.getTargetPackage());
            op.setReplaceFieldWithTemplate(dialog.isReplaceFormField());
            op.setCreateExternalFormData(dialog.isCreateExternalFormData());
            op.validate();
            new OperationJob(new IOperation[]{op}).schedule();
        }
        return null;
    }

    @Override
    public boolean canRun(IStructuredSelection selection) {
        return this.isEditable((IJavaElement)UiUtility.getTypeFromSelection(selection));
    }
}

