/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.javaelement;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class JavaElementAbstractTypeContentProvider
extends AbstractJavaElementContentProvider {
    private final IType m_superType;
    private final IJavaProject m_project;
    private final IType[] m_mostlyUsed;
    private ITypeFilter m_filter;

    public JavaElementAbstractTypeContentProvider(IType superType, IJavaProject project, IType ... mostlyUsed) {
        this(superType, project, (ITypeFilter)null, mostlyUsed);
    }

    public JavaElementAbstractTypeContentProvider(IType superType, IJavaProject project, ITypeFilter filter, IType ... mostlyUsed) {
        this.m_superType = superType;
        this.m_project = project;
        this.m_mostlyUsed = mostlyUsed;
        this.m_filter = filter;
    }

    @Override
    protected Object[][] computeProposals() {
        ITypeFilter filter = null;
        IType[] mostlyUsed = null;
        if (this.getFilter() == null) {
            filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getNotInTypes((IType[])this.m_mostlyUsed), TypeFilters.getNoSurroundingContextTypeFilter()});
            mostlyUsed = this.m_mostlyUsed;
        } else {
            filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getNotInTypes((IType[])this.m_mostlyUsed), TypeFilters.getNoSurroundingContextTypeFilter(), this.getFilter()});
            if (this.m_mostlyUsed != null) {
                ArrayList<IType> mu = new ArrayList<IType>(this.m_mostlyUsed.length);
                IType[] iTypeArray = this.m_mostlyUsed;
                int n = this.m_mostlyUsed.length;
                int n2 = 0;
                while (n2 < n) {
                    IType o = iTypeArray[n2];
                    if (TypeUtility.exists((IJavaElement)o) && this.getFilter().accept(o)) {
                        mu.add(o);
                    }
                    ++n2;
                }
                mostlyUsed = mu.toArray(new IType[mu.size()]);
            }
        }
        Set types = TypeUtility.getAbstractTypesOnClasspath((IType)this.m_superType, (IJavaProject)this.m_project, (ITypeFilter)filter);
        return new Object[][]{mostlyUsed, types.toArray(new IType[types.size()])};
    }

    public ITypeFilter getFilter() {
        return this.m_filter;
    }

    public void setFilter(ITypeFilter filter) {
        this.m_filter = filter;
        this.invalidateCache();
    }
}

