/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.signature;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.MoreElementsProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.signature.SignatureCache;

public class SignatureProposalProvider
extends ContentProposalProvider {
    public static final Set<String> DEFAULT_PRIMITIV_SIGNATURES = Collections.unmodifiableSet(CollectionUtility.hashSet((Object[])new String[]{"Z", "B", "C", "D", "F", "I", "J", "S"}));
    public static final Set<String> DEFAULT_MOST_USED = Collections.unmodifiableSet(CollectionUtility.hashSet((Object[])new String[]{SignatureCache.createTypeSignature((String)Boolean.class.getName()), SignatureCache.createTypeSignature((String)Number.class.getName()), SignatureCache.createTypeSignature((String)Integer.class.getName()), SignatureCache.createTypeSignature((String)Long.class.getName()), SignatureCache.createTypeSignature((String)Double.class.getName()), SignatureCache.createTypeSignature((String)Date.class.getName()), SignatureCache.createTypeSignature((String)String.class.getName()), SignatureCache.createTypeSignature((String)BigDecimal.class.getName()), SignatureCache.createTypeSignature((String)BigInteger.class.getName()), SignatureCache.createTypeSignature((String)Runnable.class.getName()), SignatureCache.createTypeSignature((String)Collection.class.getName()), SignatureCache.createTypeSignature((String)List.class.getName()), SignatureCache.createTypeSignature((String)Set.class.getName()), SignatureCache.createTypeSignature((String)Map.class.getName()), SignatureCache.createTypeSignature((String)Enumeration.class.getName()), SignatureCache.createTypeSignature((String)Iterable.class.getName())}));
    private SearchEngine m_searchEngine;
    private final boolean m_supportsGenerics;
    private Set<String> m_primitivSignatures;
    private final IJavaSearchScope m_searchScope;
    private Set<String> m_mostUsedSignatures;
    private final ILabelProvider m_labelProvider;
    private int m_maxProposalAmount = 100;

    public SignatureProposalProvider(IJavaSearchScope searchScope, ILabelProvider labelProvider, Set<String> mostUsedSignatures, boolean supportsGenerics) {
        this.m_searchScope = searchScope;
        this.m_labelProvider = labelProvider;
        this.m_mostUsedSignatures = mostUsedSignatures;
        this.m_supportsGenerics = supportsGenerics;
        this.m_searchEngine = new SearchEngine();
    }

    public IJavaSearchScope getSearchScope() {
        return this.m_searchScope;
    }

    public ILabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }

    public Set<String> getMostUsedSignatures() {
        return this.m_mostUsedSignatures;
    }

    public void setMostUsedSignatures(Set<String> mostUsedSignatures) {
        this.m_mostUsedSignatures = mostUsedSignatures;
    }

    public Set<String> getPrimitivSignatures() {
        return this.m_primitivSignatures;
    }

    public void setPrimitivSignatures(Set<String> primitivSignatures) {
        this.m_primitivSignatures = primitivSignatures;
    }

    public boolean isSupportsGenerics() {
        return this.m_supportsGenerics;
    }

    public void setMaxProposalAmount(int maxProposalAmount) {
        this.m_maxProposalAmount = maxProposalAmount;
    }

    public int getMaxProposalAmount() {
        return this.m_maxProposalAmount;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        Collection<Object> searchResult;
        searchPattern = !StringUtility.hasText((CharSequence)searchPattern) ? "*" : String.valueOf(IRegEx.STAR_END.matcher(searchPattern).replaceAll("")) + "*";
        int counter = 0;
        ArrayList<Object> result = new ArrayList<Object>(Math.min(this.getMaxProposalAmount(), 100));
        char[] pattern = CharOperation.toLowerCase((char[])searchPattern.toCharArray());
        if (this.getPrimitivSignatures() != null) {
            for (String sig : this.getPrimitivSignatures()) {
                if (!CharOperation.match((char[])pattern, (char[])this.getLabelProvider().getText((Object)sig).toCharArray(), (boolean)false)) continue;
                if (++counter > this.getMaxProposalAmount()) {
                    return result.toArray(new Object[result.size()]);
                }
                result.add(sig);
            }
        }
        if (this.m_mostUsedSignatures != null) {
            for (String signature : this.m_mostUsedSignatures) {
                if (!CharOperation.match((char[])pattern, (char[])this.getLabelProvider().getText((Object)signature).toCharArray(), (boolean)false)) continue;
                if (++counter > this.getMaxProposalAmount()) {
                    return result.toArray(new Object[result.size()]);
                }
                result.add(signature);
            }
        }
        if ((searchResult = this.collectTypes(searchPattern, this.getMaxProposalAmount() - counter - 1, monitor)).size() > 0) {
            if (result.size() > 0) {
                result.add(MoreElementsProposal.INSTANCE);
            }
            result.addAll(searchResult);
        }
        return result.toArray(new Object[result.size()]);
    }

    protected Collection<Object> collectTypes(String searchPattern, int maxResultSize, IProgressMonitor monitor) {
        P_SearchRequestor searchRequestor;
        block4: {
            searchRequestor = new P_SearchRequestor(monitor, maxResultSize);
            if (searchPattern.length() == 1) {
                return searchRequestor.getResult();
            }
            try {
                SearchPattern p = SearchPattern.createPattern((String)searchPattern, (int)0, (int)0, (int)2);
                if (p != null) {
                    this.m_searchEngine.search(p, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.m_searchScope, (SearchRequestor)searchRequestor, null);
                }
            }
            catch (CoreException e) {
                if (!e.getStatus().matches(4)) break block4;
                ScoutSdkUi.logWarning(e);
            }
        }
        return searchRequestor.getResult();
    }

    private class P_SearchRequestor
    extends SearchRequestor {
        private IProgressMonitor m_monitor;
        private TreeMap<CompositeObject, Object> m_foundTypes;
        private int m_requestedDecrementCounter;

        public P_SearchRequestor(IProgressMonitor monitor, int maxResultSize) {
            this.m_monitor = monitor;
            this.m_requestedDecrementCounter = maxResultSize;
            this.m_foundTypes = new TreeMap();
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.m_monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.scout.sdk.ui", "canceled by monitor"));
            }
            if (match instanceof TypeDeclarationMatch) {
                IType type = (IType)match.getElement();
                if (!SignatureProposalProvider.this.isSupportsGenerics() && type.getTypeParameters().length > 0) {
                    return;
                }
                this.m_foundTypes.put(new CompositeObject(new Object[]{"A", type.getElementName(), type.getFullyQualifiedName()}), SignatureCache.createTypeSignature((String)type.getFullyQualifiedName()));
                if (--this.m_requestedDecrementCounter <= 0) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.scout.sdk.ui", "stopped after " + SignatureProposalProvider.this.getMaxProposalAmount()));
                }
            }
        }

        public Collection<Object> getResult() {
            return this.m_foundTypes.values();
        }
    }
}

